/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPriorityNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;

public class DefinitionPrinter<T>
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final VisitController visitController;
    private final T chunk;
    private final StringBuilder sb = new StringBuilder();
    private boolean printDefinition;

    public DefinitionPrinter(VisitController visitController, T chunk) {
        this.visitController = visitController;
        this.chunk = chunk;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode definition) {
        this.printDefinition = this.chunk.equals(definition.getChunk());
        if (this.printDefinition) {
            this.sb.append("@def ").append(definition.getName()).append(' ');
        }
        return this.printDefinition;
    }

    @Override
    public void leaveDefinition(CssDefinitionNode node) {
        if (this.printDefinition) {
            this.sb.append(";\n");
            this.printDefinition = false;
        }
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (!this.printDefinition) {
            return false;
        }
        if (node instanceof CssPriorityNode) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        this.sb.append(node);
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (!this.printDefinition) {
            return;
        }
        this.sb.append(' ');
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        if (!this.printDefinition) {
            return false;
        }
        this.sb.append(node.getFunctionName());
        this.sb.append('(');
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        if (!this.printDefinition) {
            return;
        }
        this.sb.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        if (!this.printDefinition) {
            return false;
        }
        this.deleteLastCharIfCharIs(' ');
        this.sb.append(node);
        return true;
    }

    public String getDefinitionGss() {
        return this.sb.toString();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private void deleteLastCharIfCharIs(char ch) {
        if (this.sb.charAt(this.sb.length() - 1) == ch) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
    }
}

