/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.SkippingTreeVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;

public class SplitRulesetNodes
extends SkippingTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;

    public SplitRulesetNodes(MutatingVisitController visitController) {
        this(visitController, false);
    }

    public SplitRulesetNodes(MutatingVisitController visitController, boolean skipping) {
        super(skipping);
        this.visitController = visitController;
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        boolean canModifyRuleset = this.canModifyRuleset(node);
        if (canModifyRuleset) {
            ArrayList replacementNodes = Lists.newArrayList();
            CssSelectorListNode selectors = node.getSelectors();
            CssDeclarationBlockNode declarations = node.getDeclarations();
            for (CssSelectorNode sel : selectors.childIterable()) {
                for (CssNode child : declarations.childIterable()) {
                    CssRulesetNode ruleset = new CssRulesetNode();
                    ruleset.addDeclaration(child.deepCopy());
                    ruleset.addSelector(sel.deepCopy());
                    replacementNodes.add(ruleset);
                }
            }
            this.visitController.replaceCurrentBlockChildWith(replacementNodes, false);
        }
        return canModifyRuleset;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

