/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapConsumer;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapLineDecoder;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapParseException;
import com.google.gwt.thirdparty.debugging.sourcemap.proto.Mapping;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.json.JSONArray;
import com.google.gwt.thirdparty.json.JSONException;
import com.google.gwt.thirdparty.json.JSONObject;
import java.util.List;
import java.util.Map;

public class SourceMapConsumerV2
implements SourceMapConsumer {
    private Map<Integer, List<Integer>> characterMap = null;
    private JSONArray lineMaps = null;
    private List<Mapping.OriginalMapping> mappings;

    @Override
    public void parse(String contents) throws SourceMapParseException {
        try {
            JSONObject sourceMapRoot = new JSONObject(contents);
            this.parse(sourceMapRoot);
        }
        catch (JSONException ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
    }

    public void parse(JSONObject sourceMapRoot) throws SourceMapParseException {
        try {
            this.parseInternal(sourceMapRoot);
        }
        catch (JSONException ex) {
            throw new SourceMapParseException("JSON parse exception: " + ex);
        }
    }

    private void parseInternal(JSONObject sourceMapRoot) throws JSONException, SourceMapParseException {
        int version2 = sourceMapRoot.getInt("version");
        if (version2 != 2) {
            throw new SourceMapParseException("Unknown version: " + version2);
        }
        String file = sourceMapRoot.getString("file");
        if (file.isEmpty()) {
            throw new SourceMapParseException("File entry is missing or empty");
        }
        int lineCount = sourceMapRoot.getInt("lineCount");
        this.lineMaps = sourceMapRoot.getJSONArray("lineMaps");
        if (lineCount != this.lineMaps.length()) {
            throw new SourceMapParseException("lineMaps length does not match lineCount");
        }
        this.characterMap = Maps.newHashMap();
        JSONArray sources = sourceMapRoot.getJSONArray("sources");
        JSONArray names = sourceMapRoot.has("names") ? sourceMapRoot.getJSONArray("names") : null;
        JSONArray jsonMappings = sourceMapRoot.getJSONArray("mappings");
        this.mappings = Lists.newArrayListWithCapacity((int)lineCount);
        for (int i = 0; i < jsonMappings.length(); ++i) {
            JSONArray entry = jsonMappings.getJSONArray(i);
            String name = entry.optString(3, "");
            if (names != null) {
                try {
                    int nameIndex = entry.getInt(3);
                    name = names.getString(nameIndex);
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            String sourceFile = sources.getString(entry.getInt(0));
            int lineNumber = entry.getInt(1);
            int column = entry.getInt(2);
            Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setOriginalFile(sourceFile).setLineNumber(lineNumber).setColumnPosition(column).setIdentifier(name);
            this.mappings.add(builder.build());
        }
    }

    @Override
    public Mapping.OriginalMapping getMappingForLine(int lineNumber, int columnIndex) {
        List<Integer> map;
        --columnIndex;
        if (--lineNumber >= this.lineMaps.length()) {
            return null;
        }
        Preconditions.checkState((lineNumber >= 0 ? 1 : 0) != 0, (Object)"Line number must be >= 0");
        Preconditions.checkState((columnIndex >= 0 ? 1 : 0) != 0, (Object)"Column index must be >= 0");
        if (!this.characterMap.containsKey(lineNumber)) {
            try {
                this.characterMap.put(lineNumber, SourceMapLineDecoder.decodeLine(this.lineMaps.getString(lineNumber)));
            }
            catch (JSONException jse) {
                throw new IllegalStateException("JSON exception when retrieving line map", jse);
            }
        }
        if ((map = this.characterMap.get(lineNumber)) == null || map.size() <= columnIndex) {
            return null;
        }
        int index = map.get(columnIndex);
        if (index == -1) {
            return null;
        }
        Preconditions.checkState((index < this.mappings.size() ? 1 : 0) != 0, (Object)"Invalid mapping reference");
        return this.mappings.get(index);
    }
}

