/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.ant;

import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.CommandLineRunner;
import com.google.gwt.thirdparty.javascript.jscomp.CompilationLevel;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerOptions;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticGroup;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticGroups;
import com.google.gwt.thirdparty.javascript.jscomp.MessageFormatter;
import com.google.gwt.thirdparty.javascript.jscomp.Result;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.SourceMap;
import com.google.gwt.thirdparty.javascript.jscomp.WarningLevel;
import com.google.gwt.thirdparty.javascript.jscomp.ant.AntErrorManager;
import com.google.gwt.thirdparty.javascript.jscomp.ant.Warning;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;

public final class CompileTask
extends Task {
    private CompilerOptions.LanguageMode languageIn = CompilerOptions.LanguageMode.ECMASCRIPT3;
    private WarningLevel warningLevel = WarningLevel.DEFAULT;
    private boolean debugOptions = false;
    private String encoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private boolean customExternsOnly = false;
    private boolean manageDependencies = false;
    private boolean prettyPrint = false;
    private boolean printInputDelimiter = false;
    private boolean generateExports = false;
    private boolean replaceProperties = false;
    private boolean forceRecompile = false;
    private String replacePropertiesPrefix = "closure.define.";
    private File outputFile;
    private final List<Parameter> defineParams = Lists.newLinkedList();
    private final List<FileList> externFileLists = Lists.newLinkedList();
    private final List<FileList> sourceFileLists = Lists.newLinkedList();
    private final List<Path> sourcePaths = Lists.newLinkedList();
    private final List<Warning> warnings = Lists.newLinkedList();
    private String sourceMapFormat;
    private File sourceMapOutputFile;

    public void setLanguageIn(String value) {
        if (value.equals("ECMASCRIPT5_STRICT") || value.equals("ES5_STRICT")) {
            this.languageIn = CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT;
        } else if (value.equals("ECMASCRIPT5") || value.equals("ES5")) {
            this.languageIn = CompilerOptions.LanguageMode.ECMASCRIPT5;
        } else if (value.equals("ECMASCRIPT3") || value.equals("ES3")) {
            this.languageIn = CompilerOptions.LanguageMode.ECMASCRIPT3;
        } else {
            throw new BuildException("Unrecognized 'languageIn' option value (" + value + ")");
        }
    }

    public void setWarning(String value) {
        if ("default".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.DEFAULT;
        } else if ("quiet".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.QUIET;
        } else if ("verbose".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.VERBOSE;
        } else {
            throw new BuildException("Unrecognized 'warning' option value (" + value + ")");
        }
    }

    public void setDebug(boolean value) {
        this.debugOptions = value;
    }

    public void setCompilationLevel(String value) {
        if ("simple".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        } else if ("advanced".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.ADVANCED_OPTIMIZATIONS;
        } else if ("whitespace".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.WHITESPACE_ONLY;
        } else {
            throw new BuildException("Unrecognized 'compilation' option value (" + value + ")");
        }
    }

    public void setManageDependencies(boolean value) {
        this.manageDependencies = value;
    }

    public void setCustomExternsOnly(boolean value) {
        this.customExternsOnly = value;
    }

    public void setOutput(File value) {
        this.outputFile = value;
    }

    public void setReplacePropertiesPrefix(String value) {
        this.replacePropertiesPrefix = value;
    }

    public void setReplaceProperties(boolean value) {
        this.replaceProperties = value;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setPrettyPrint(boolean pretty) {
        this.prettyPrint = pretty;
    }

    public void setPrintInputDelimiter(boolean print) {
        this.printInputDelimiter = print;
    }

    public void setForceRecompile(boolean forceRecompile) {
        this.forceRecompile = forceRecompile;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void addExterns(FileList list) {
        this.externFileLists.add(list);
    }

    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    public void addSources(FileList list) {
        this.sourceFileLists.add(list);
    }

    public void addPath(Path list) {
        this.sourcePaths.add(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute must be set");
        }
        Compiler.setLoggingLevel(Level.OFF);
        CompilerOptions options = this.createCompilerOptions();
        Compiler compiler = this.createCompiler(options);
        List<SourceFile> externs = this.findExternFiles();
        List<SourceFile> sources = this.findSourceFiles();
        if (this.isStale() || this.forceRecompile) {
            this.log("Compiling " + sources.size() + " file(s) with " + externs.size() + " extern(s)");
            Result result = compiler.compile(externs, sources, options);
            if (!result.success) throw new BuildException("Compilation failed.");
            StringBuilder source = new StringBuilder(compiler.toSource());
            if (result.sourceMap != null) {
                this.flushSourceMap(result.sourceMap);
                source.append(System.getProperty("line.separator"));
                source.append("//@ sourceMappingURL=" + this.sourceMapOutputFile.getName());
            }
            this.writeResult(source.toString());
            return;
        } else {
            this.log("None of the files changed. Compilation skipped.");
        }
    }

    private void flushSourceMap(SourceMap sourceMap) {
        try {
            FileWriter out = new FileWriter(this.sourceMapOutputFile);
            sourceMap.appendTo(out, this.sourceMapOutputFile.getName());
            out.close();
        }
        catch (IOException e) {
            throw new BuildException("Cannot write sourcemap to file.", (Throwable)e);
        }
    }

    private CompilerOptions createCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        if (this.debugOptions) {
            this.compilationLevel.setDebugOptionsForCompilationLevel(options);
        }
        options.prettyPrint = this.prettyPrint;
        options.printInputDelimiter = this.printInputDelimiter;
        options.generateExports = this.generateExports;
        options.setLanguageIn(this.languageIn);
        this.warningLevel.setOptionsForWarningLevel(options);
        options.setManageClosureDependencies(this.manageDependencies);
        if (this.replaceProperties) {
            this.convertPropertiesMap(options);
        }
        this.convertDefineParameters(options);
        for (Warning warning : this.warnings) {
            CheckLevel level = warning.getLevel();
            String groupName = warning.getGroup();
            DiagnosticGroup group = new DiagnosticGroups().forName(groupName);
            if (group == null) {
                throw new BuildException("Unrecognized 'warning' option value (" + groupName + ")");
            }
            options.setWarningLevel(group, level);
        }
        if (!Strings.isNullOrEmpty((String)this.sourceMapFormat)) {
            options.sourceMapFormat = SourceMap.Format.valueOf(this.sourceMapFormat);
        }
        if (this.sourceMapOutputFile != null) {
            File parentFile = this.sourceMapOutputFile.getParentFile();
            if (parentFile.mkdirs()) {
                this.log("Created missing parent directory " + parentFile, 4);
            }
            options.sourceMapOutputPath = parentFile.getAbsolutePath();
        }
        return options;
    }

    public Parameter createDefine() {
        Parameter param = new Parameter();
        this.defineParams.add(param);
        return param;
    }

    private void convertDefineParameters(CompilerOptions options) {
        for (Parameter p : this.defineParams) {
            String value;
            String key = p.getName();
            if (this.setDefine(options, key, value = p.getValue())) continue;
            this.log("Unexpected @define value for name=" + key + "; value=" + value);
        }
    }

    private void convertPropertiesMap(CompilerOptions options) {
        Hashtable props = this.getProject().getProperties();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith(this.replacePropertiesPrefix) || this.setDefine(options, key = key.substring(this.replacePropertiesPrefix.length()), value)) continue;
            this.log("Unexpected property value for key=" + key + "; value=" + value);
        }
    }

    private boolean setDefine(CompilerOptions options, String key, Object value) {
        boolean success = false;
        if (value instanceof String) {
            boolean isTrue = "true".equals(value);
            boolean isFalse = "false".equals(value);
            if (isTrue || isFalse) {
                options.setDefineToBooleanLiteral(key, isTrue);
            } else {
                try {
                    double dblTemp = Double.parseDouble((String)value);
                    options.setDefineToDoubleLiteral(key, dblTemp);
                }
                catch (NumberFormatException nfe) {
                    options.setDefineToStringLiteral(key, (String)value);
                }
            }
            success = true;
        } else if (value instanceof Boolean) {
            options.setDefineToBooleanLiteral(key, (Boolean)value);
            success = true;
        } else if (value instanceof Integer) {
            options.setDefineToNumberLiteral(key, (Integer)value);
            success = true;
        } else if (value instanceof Double) {
            options.setDefineToDoubleLiteral(key, (Double)value);
            success = true;
        }
        return success;
    }

    private Compiler createCompiler(CompilerOptions options) {
        Compiler compiler = new Compiler();
        MessageFormatter formatter = options.errorFormat.toFormatter(compiler, false);
        AntErrorManager errorManager = new AntErrorManager(formatter, this);
        compiler.setErrorManager(errorManager);
        return compiler;
    }

    private List<SourceFile> findExternFiles() {
        LinkedList files = Lists.newLinkedList();
        if (!this.customExternsOnly) {
            files.addAll(this.getDefaultExterns());
        }
        for (FileList list : this.externFileLists) {
            files.addAll(this.findJavaScriptFiles(list));
        }
        return files;
    }

    private List<SourceFile> findSourceFiles() {
        LinkedList files = Lists.newLinkedList();
        for (FileList fileList : this.sourceFileLists) {
            files.addAll(this.findJavaScriptFiles(fileList));
        }
        for (Path path : this.sourcePaths) {
            files.addAll(this.findJavaScriptFiles(path));
        }
        return files;
    }

    private List<SourceFile> findJavaScriptFiles(FileList fileList) {
        LinkedList files = Lists.newLinkedList();
        File baseDir = fileList.getDir(this.getProject());
        for (String included : fileList.getFiles(this.getProject())) {
            files.add(SourceFile.fromFile(new File(baseDir, included), Charset.forName(this.encoding)));
        }
        return files;
    }

    private List<SourceFile> findJavaScriptFiles(Path path) {
        ArrayList files = Lists.newArrayList();
        for (String included : path.list()) {
            files.add(SourceFile.fromFile(new File(included), Charset.forName(this.encoding)));
        }
        return files;
    }

    private List<SourceFile> getDefaultExterns() {
        try {
            return CommandLineRunner.getDefaultExterns();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeResult(String source) {
        if (this.outputFile.getParentFile().mkdirs()) {
            this.log("Created missing parent directory " + this.outputFile.getParentFile(), 4);
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.outputEncoding);
            out.append(source);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Compiled JavaScript written to " + this.outputFile.getAbsolutePath(), 4);
    }

    private boolean isStale() {
        long lastRun = this.outputFile.lastModified();
        long sourcesLastModified = Math.max(this.getLastModifiedTime(this.sourceFileLists), this.getLastModifiedTime(this.sourcePaths));
        long externsLastModified = this.getLastModifiedTime(this.externFileLists);
        return lastRun <= sourcesLastModified || lastRun <= externsLastModified;
    }

    private long getLastModifiedTime(List<?> fileLists) {
        long lastModified = 0L;
        for (Object entry : fileLists) {
            if (entry instanceof FileList) {
                FileList list = (FileList)entry;
                for (String fileName : list.getFiles(this.getProject())) {
                    File path = list.getDir(this.getProject());
                    File file = new File(path, fileName);
                    lastModified = Math.max(this.getLastModifiedTime(file), lastModified);
                }
                continue;
            }
            if (!(entry instanceof Path)) continue;
            Path path = (Path)entry;
            for (String src : path.list()) {
                File file = new File(src);
                lastModified = Math.max(this.getLastModifiedTime(file), lastModified);
            }
        }
        return lastModified;
    }

    private long getLastModifiedTime(File file) {
        long fileLastModified = file.lastModified();
        if (fileLastModified == 0L) {
            fileLastModified = new Date().getTime();
        }
        return fileLastModified;
    }

    public void setSourceMapFormat(String format) {
        this.sourceMapFormat = format;
    }

    public void setSourceMapOutputFile(File sourceMapOutputFile) {
        this.sourceMapOutputFile = sourceMapOutputFile;
    }
}

