/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.LRUCache;
import java.util.Arrays;
import java.util.Comparator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LRUCacheTest {
    @Test
    public void testLRU() {
        LRUCache cut = new LRUCache(3);
        String f = "foo";
        String br = "bar";
        cut.put((Object)"foo", (Object)"bar");
        cut.put((Object)"bar", (Object)"baz");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, cut.getKeys().toArray()), (String)"invalid order of items, initially it should be insertion ordered");
        cut.get((Object)"foo");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"bar", "foo"}, cut.getKeys().toArray()), (String)"invalid order of items, accessing foo should move it to the end");
        cut.get((Object)"bar");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, cut.getKeys().toArray()), (String)"invalid order of items");
        cut.get((Object)"foo");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"bar", "foo"}, cut.getKeys().toArray()), (String)"invalid order of items, accessing foo should move it to the end");
        cut.put((Object)"baz", (Object)"foo");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"bar", "foo", "baz"}, cut.getKeys().toArray()), (String)"invalid order of items, last inserted item should be at last position");
    }

    @Test
    public void testRemove() {
        LRUCache cut = new LRUCache(3);
        cut.put((Object)"foo", (Object)"bar");
        Assert.assertTrue((boolean)cut.containsKey((Object)"foo"));
        Assert.assertEquals((String)((String)cut.remove((Object)"foo")), (String)"bar");
        Assert.assertFalse((boolean)cut.containsKey((Object)"foo"));
    }

    @Test
    public void testCacheSize() {
        LRUCache cut = new LRUCache(1);
        cut.put((Object)"foo", (Object)"bar");
        Assert.assertEquals((String)"bar", (String)((String)cut.get((Object)"foo")));
        cut.put((Object)"bar", (Object)"baz");
        Assert.assertEquals((String)"baz", (String)((String)cut.get((Object)"bar")));
        Assert.assertNull((Object)cut.get((Object)"foo"), (String)"old key still existing, unexpected cache size");
    }

    @Test
    public void testCacheTTL() throws InterruptedException {
        LRUCache cut = new LRUCache(1, 100L);
        cut.put((Object)"foo", (Object)"bar");
        Assert.assertEquals((String)"bar", (String)((String)cut.get((Object)"foo")));
        Thread.sleep(120L);
        Assert.assertNull((Object)cut.get((Object)"foo"), (String)"expired key still existing, unexpected cache size");
    }

    @Test
    public void testGetKeysSortedByValue() {
        LRUCache cut = new LRUCache(3);
        String f = "foo";
        String br = "bar";
        cut.put((Object)"foo", (Object)1);
        cut.put((Object)"bar", (Object)2);
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, cut.getKeysSortedByValue((Comparator)c).toArray()), (String)"invalid order of items, the keys are not order by their values");
        cut.put((Object)"foo", (Object)3);
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"bar", "foo"}, cut.getKeysSortedByValue((Comparator)c).toArray()), (String)"invalid order of items, the keys are not order by their values");
    }

    @Test
    public void testClear() {
        LRUCache cut = new LRUCache(3);
        cut.put((Object)"foo", (Object)1);
        cut.clear();
        Assert.assertNull((Object)cut.get((Object)"foo"));
    }
}

