/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.ReadOnlyRequestsCache;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyRequestsCacheTest {
    @Test
    public void testRegisterReadOnlyAndModifyingRequests() {
        ReadOnlyRequestsCache cut = new ReadOnlyRequestsCache();
        cut.readOnlyRequest("foo");
        this.readOnlyRequestsShouldContain(cut, "foo", true);
        cut.modifyingRequest("foo");
        this.readOnlyRequestsShouldContain(cut, "foo", false);
        cut.modifyingRequest("bar");
        this.readOnlyRequestsShouldContain(cut, "bar", false);
        cut.readOnlyRequest("bar");
        this.readOnlyRequestsShouldContain(cut, "bar", false);
    }

    @Test
    public void testGetReadOnlyRequestsByFrequency() {
        ReadOnlyRequestsCache cut = new ReadOnlyRequestsCache();
        cut.readOnlyRequest("foo");
        cut.readOnlyRequest("bar");
        cut.readOnlyRequest("bar");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, cut.getReadOnlyRequestsByFrequency().toArray()));
        cut.readOnlyRequest("foo");
        cut.readOnlyRequest("foo");
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"bar", "foo"}, cut.getReadOnlyRequestsByFrequency().toArray()));
    }

    private void readOnlyRequestsShouldContain(ReadOnlyRequestsCache cut, String key, boolean shouldBeContained) {
        Assert.assertEquals((boolean)cut.isReadOnlyRequest(key), (boolean)shouldBeContained);
        Assert.assertEquals((boolean)cut.getReadOnlyRequests().contains(key), (boolean)shouldBeContained);
        Assert.assertEquals((boolean)cut.getReadOnlyRequestsByFrequency().contains(key), (boolean)shouldBeContained);
    }
}

