/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.StorageKeyFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SessionIdFormatTest {
    @Test
    public void testCreateSessionId() {
        SessionIdFormat cut = new SessionIdFormat();
        Assert.assertEquals((String)"foo-n", (String)cut.createSessionId("foo", "n"));
        Assert.assertEquals((String)"foo-n.jvm1", (String)cut.createSessionId("foo.jvm1", "n"));
        Assert.assertEquals((String)"foo-n.j-v-m1", (String)cut.createSessionId("foo.j-v-m1", "n"));
    }

    @Test
    public void testCreateNewSessionId() {
        SessionIdFormat cut = new SessionIdFormat();
        Assert.assertEquals((String)"foo-n", (String)cut.createNewSessionId("foo", "n"));
        Assert.assertEquals((String)"foo-m", (String)cut.createNewSessionId("foo-n", "m"));
        Assert.assertEquals((String)"foo-m.jvm1", (String)cut.createNewSessionId("foo-n.jvm1", "m"));
        Assert.assertEquals((String)"foo-m.jvm1", (String)cut.createNewSessionId("foo.jvm1", "m"));
        Assert.assertEquals((String)"foo-m.j-v-m1", (String)cut.createNewSessionId("foo.j-v-m1", "m"));
    }

    @Test
    public void testExtractMemcachedId() throws InterruptedException {
        SessionIdFormat cut = new SessionIdFormat();
        Assert.assertEquals((String)"n", (String)cut.extractMemcachedId("foo-n"));
        Assert.assertEquals((String)"n", (String)cut.extractMemcachedId("foo-n.jvm1"));
        Assert.assertEquals((String)"n", (String)cut.extractMemcachedId("foo-n.j-v-m1"));
        Assert.assertEquals(null, (String)cut.extractMemcachedId("foo.j-v-m1"));
    }

    @Test
    public void testIsValid() throws InterruptedException {
        SessionIdFormat cut = new SessionIdFormat();
        Assert.assertFalse((boolean)cut.isValid("foo"));
        Assert.assertFalse((boolean)cut.isValid("foo.jvm1-n"));
        Assert.assertFalse((boolean)cut.isValid("foo.n.jvm1"));
        Assert.assertFalse((boolean)cut.isValid("foo.n.j-v-m1"));
        Assert.assertTrue((boolean)cut.isValid("foo-n"));
        Assert.assertTrue((boolean)cut.isValid("foo-n.jvm1"));
        Assert.assertTrue((boolean)cut.isValid("foo-n.j-v-m1"));
    }

    @Test
    public void testCreateBackupKey() {
        SessionIdFormat cut = new SessionIdFormat(StorageKeyFormat.ofHost((String)"localhost"));
        Assert.assertEquals((String)cut.createBackupKey("foo"), (String)"bak:localhost_foo");
    }

    @Test
    public void testIsBackupKey() {
        SessionIdFormat cut = new SessionIdFormat(StorageKeyFormat.ofHost((String)"localhost"));
        Assert.assertTrue((boolean)cut.isBackupKey("bak:localhost_foo"));
    }

    @Test
    public void testCreateLockName() {
        SessionIdFormat cut = new SessionIdFormat(StorageKeyFormat.ofHost((String)"localhost"));
        Assert.assertEquals((String)cut.createLockName("foo"), (String)"lock:localhost_foo");
    }

    @Test
    public void testCreateValidityInfoKeyName() {
        SessionIdFormat cut = new SessionIdFormat(StorageKeyFormat.ofHost((String)"localhost"));
        Assert.assertEquals((String)cut.createValidityInfoKeyName("foo"), (String)"validity:localhost_foo");
    }
}

