/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TestServlet
extends HttpServlet {
    public static final String ID = "id";
    public static final String PATH_WAIT = "/sleep";
    public static final String PARAM_WAIT = "sleep";
    public static final String PARAM_MILLIS = "millies";
    public static final String PARAM_REMOVE = "remove";
    public static final String PATH_GET_REQUESTED_SESSION_INFO = "/requestedSessionInfo";
    public static final String KEY_REQUESTED_SESSION_ID = "requestedSessionId";
    public static final String KEY_IS_REQUESTED_SESSION_ID_VALID = "isRequestedSessionIdValid";
    public static final String PATH_NO_SESSION_ACCESS = "/noSessionAccess";
    public static final String PATH_INVALIDATE = "/invalidate";
    private static final long serialVersionUID = 7954803132860358448L;
    private static final Log LOG = LogFactory.getLog(TestServlet.class);
    private DefaultServlet defaultServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.defaultServlet = new DefaultServlet();
        this.defaultServlet.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        LOG.info((Object)(" + starting " + pathInfo + "..."));
        if ("/pixel.gif".equals(pathInfo)) {
            this.defaultServlet.service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (PATH_GET_REQUESTED_SESSION_INFO.equals(pathInfo)) {
            LOG.info((Object)("getRequestedSessionId: " + request.getRequestedSessionId()));
            LOG.info((Object)("isRequestedSessionIdValid: " + request.isRequestedSessionIdValid()));
            PrintWriter out = response.getWriter();
            out.println("requestedSessionId=" + request.getRequestedSessionId());
            out.println("isRequestedSessionIdValid=" + request.isRequestedSessionIdValid());
        } else if (PATH_NO_SESSION_ACCESS.equals(pathInfo)) {
            LOG.info((Object)"skipping session access");
            response.getWriter().println("Skipped session access");
        } else if (PATH_INVALIDATE.equals(pathInfo)) {
            HttpSession session = request.getSession(false);
            LOG.info((Object)("Invalidating session " + session.getId()));
            session.invalidate();
            response.getWriter().println("Invalidated session " + session.getId());
        } else {
            HttpSession session = request.getSession();
            this.waitIfRequested(request);
            String removeKey = request.getParameter(PARAM_REMOVE);
            if (removeKey != null && !"".equals(removeKey)) {
                String[] keys = removeKey.split(",");
                LOG.info((Object)("Removing " + (keys.length > 1 ? "keys " : "key ") + Arrays.asList(keys)));
                for (String key : keys) {
                    session.removeAttribute(key);
                }
            }
            PrintWriter out = response.getWriter();
            out.println("id=" + session.getId());
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String name = attributeNames.nextElement().toString();
                Object value = session.getAttribute(name);
                out.println(name + "=" + value);
            }
        }
        LOG.info((Object)" - finished.");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.info((Object)"invoked");
        HttpSession session = request.getSession();
        this.waitIfRequested(request);
        PrintWriter out = response.getWriter();
        out.println("OK: " + session.getId());
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            session.setAttribute(name, (Object)value);
        }
    }

    private void waitIfRequested(HttpServletRequest request) throws ServletException {
        String pathInfo = request.getPathInfo();
        if (PATH_WAIT.equals(pathInfo) || request.getParameter(PARAM_WAIT) != null) {
            try {
                Thread.sleep(Long.parseLong(request.getParameter(PARAM_MILLIS)));
            }
            catch (Exception e) {
                throw new ServletException("Could not sleep.", (Throwable)e);
            }
        }
    }
}

