/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.hibernate;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.integration.TestUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.catalina.core.StandardContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.annotations.AttributeAccessor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Restrictions;
import org.hibernate.service.ServiceRegistry;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public abstract class AbstractHibernateCollectionsTest {
    private static final Log LOG = LogFactory.getLog(AbstractHibernateCollectionsTest.class);
    private SessionFactory _sessionFactory;

    @BeforeTest
    protected void beforeTest() {
        Configuration configuration = new Configuration().addAnnotatedClass(Person.class).addAnnotatedClass(Animal.class).configure();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        this._sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
    }

    @Test(enabled=true)
    public void testDeserializeHibernateCollection() {
        MemcachedSessionService.SessionManager manager = this.createSessionManager();
        HashSet<Animal> animals = new HashSet<Animal>(Arrays.asList(new Animal("cat")));
        Person person = new Person("foo bar", animals);
        Long personId = this.createPerson(person);
        Person foundPerson = this.findPerson(personId);
        LOG.info((Object)("person: " + person.toString()));
        LOG.info((Object)("found: " + foundPerson.toString()));
        TestUtils.assertDeepEquals(person, foundPerson);
        TranscoderService transcoderService = new TranscoderService(this.createTranscoder(manager));
        MemcachedBackupSession session = AbstractHibernateCollectionsTest.createSession(manager, "123456789");
        session.setAttribute("person", (Object)foundPerson);
        byte[] data = transcoderService.serialize(session);
        MemcachedBackupSession deserialized = transcoderService.deserialize(data, manager);
        Person deserializedPerson = (Person)deserialized.getAttribute("person");
        TestUtils.assertDeepEquals(foundPerson, deserializedPerson);
    }

    protected abstract SessionAttributesTranscoder createTranscoder(MemcachedSessionService.SessionManager var1);

    private Person findPerson(final Long personId) {
        Person foundPerson = this.withSession(new Callback<Person>(){

            @Override
            public Person execute(Session session) {
                Criteria crit = session.createCriteria(Person.class).add(Restrictions.idEq((Object)personId));
                List list = crit.list();
                Assert.assertEquals((int)list.size(), (int)1);
                Person result = (Person)list.get(0);
                Hibernate.initialize(result.animals);
                return result;
            }
        });
        return foundPerson;
    }

    private Long createPerson(final Person person) {
        Long personId = this.withSession(new Callback<Long>(){

            @Override
            public Long execute(Session session) {
                return (Long)session.save((Object)person);
            }
        });
        return personId;
    }

    <T> T withSession(Callback<T> callback) {
        Session session = this._sessionFactory.openSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            T result = callback.execute(session);
            transaction.commit();
            T t = result;
            return t;
        }
        catch (HibernateException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    @Nonnull
    protected MemcachedSessionService.SessionManager createSessionManager() {
        MemcachedSessionService.SessionManager manager = (MemcachedSessionService.SessionManager)Mockito.mock(MemcachedSessionService.SessionManager.class);
        StandardContext context = TestUtils.createContext();
        Mockito.when((Object)manager.getContext()).thenReturn((Object)context);
        Mockito.when((Object)manager.getContainer()).thenReturn((Object)context);
        Mockito.when((Object)manager.getMemcachedSessionService()).thenReturn((Object)this.newMemcachedSessionService(manager));
        Mockito.when((Object)manager.newMemcachedBackupSession()).thenReturn((Object)new MemcachedBackupSession(manager));
        Mockito.when((Object)manager.willAttributeDistribute(Matchers.anyString(), Matchers.anyObject())).thenReturn((Object)true);
        return manager;
    }

    protected MemcachedSessionService newMemcachedSessionService(MemcachedSessionService.SessionManager manager) {
        return new MemcachedSessionService(manager);
    }

    private static MemcachedBackupSession createSession(MemcachedSessionService.SessionManager manager, String id) {
        MemcachedBackupSession session = manager.getMemcachedSessionService().createEmptySession();
        session.setId(id);
        session.setValid(true);
        return session;
    }

    static interface Callback<T> {
        public T execute(Session var1);
    }

    @Entity(name="animals")
    @AttributeAccessor(value="field")
    static class Animal
    implements Serializable {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        public Long id;
        public String name;

        public Animal() {
        }

        public Animal(String name) {
            this.name = name;
        }

        public String toString() {
            return "Animal [id=" + this.id + ", name=" + this.name + "]";
        }
    }

    @Entity(name="persons")
    @AttributeAccessor(value="field")
    static class Person
    implements Serializable {
        @Id
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        public Long id;
        public String name;
        @OneToMany(cascade={CascadeType.ALL})
        public Set<Animal> animals;

        public Person() {
        }

        public Person(String name, Set<Animal> animals) {
            this.name = name;
            this.animals = animals;
        }

        public String toString() {
            return "Person [id=" + this.id + ", name=" + this.name + ", animals=" + this.animals + "]";
        }
    }
}

