/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns;

import io.activej.async.exception.AsyncCloseException;
import io.activej.async.exception.AsyncTimeoutException;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.dns.AsyncDnsClient;
import io.activej.dns.protocol.DnsProtocol;
import io.activej.dns.protocol.DnsQuery;
import io.activej.dns.protocol.DnsQueryException;
import io.activej.dns.protocol.DnsResponse;
import io.activej.dns.protocol.DnsTransaction;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanWithStats;
import io.activej.eventloop.net.DatagramSocketSettings;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.net.socket.udp.AsyncUdpSocket;
import io.activej.net.socket.udp.AsyncUdpSocketNio;
import io.activej.net.socket.udp.UdpPacket;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.promise.SettablePromise;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteAsyncDnsClient
implements AsyncDnsClient,
EventloopJmxBeanWithStats,
WithInitializer<RemoteAsyncDnsClient> {
    private final Logger logger = LoggerFactory.getLogger(RemoteAsyncDnsClient.class);
    private static final boolean CHECK = Checks.isEnabled(RemoteAsyncDnsClient.class);
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(3L);
    private static final int DNS_SERVER_PORT = 53;
    public static final InetSocketAddress GOOGLE_PUBLIC_DNS = new InetSocketAddress("8.8.8.8", 53);
    public static final InetSocketAddress LOCAL_DNS = new InetSocketAddress("192.168.0.1", 53);
    private final Eventloop eventloop;
    private final Map<DnsTransaction, SettablePromise<DnsResponse>> transactions = new HashMap<DnsTransaction, SettablePromise<DnsResponse>>();
    private DatagramSocketSettings datagramSocketSettings = DatagramSocketSettings.create();
    private InetSocketAddress dnsServerAddress = GOOGLE_PUBLIC_DNS;
    private Duration timeout = DEFAULT_TIMEOUT;
    @Nullable
    private AsyncUdpSocket socket;
    @Nullable
    private AsyncUdpSocketNio.Inspector socketInspector;
    @Nullable
    private Inspector inspector;

    private RemoteAsyncDnsClient(Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    public static RemoteAsyncDnsClient create(Eventloop eventloop) {
        return new RemoteAsyncDnsClient(eventloop);
    }

    public RemoteAsyncDnsClient withDatagramSocketSetting(DatagramSocketSettings setting) {
        this.datagramSocketSettings = setting;
        return this;
    }

    public RemoteAsyncDnsClient withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public RemoteAsyncDnsClient withDnsServerAddress(InetSocketAddress address) {
        this.dnsServerAddress = address;
        return this;
    }

    public RemoteAsyncDnsClient withDnsServerAddress(InetAddress address) {
        this.dnsServerAddress = new InetSocketAddress(address, 53);
        return this;
    }

    public RemoteAsyncDnsClient withInspector(Inspector inspector) {
        this.inspector = inspector;
        return this;
    }

    public RemoteAsyncDnsClient setSocketInspector(AsyncUdpSocketNio.Inspector socketInspector) {
        this.socketInspector = socketInspector;
        return this;
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    @Override
    public void close() {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if (this.socket == null) {
            return;
        }
        this.socket.close();
        this.socket = null;
        AsyncCloseException asyncCloseException = new AsyncCloseException();
        this.transactions.values().forEach(s -> s.setException((Exception)asyncCloseException));
    }

    private Promise<AsyncUdpSocket> getSocket() {
        AsyncUdpSocket socket = this.socket;
        if (socket != null) {
            return Promise.of((Object)socket);
        }
        try {
            this.logger.trace("Incoming query, opening UDP socket");
            DatagramChannel channel = Eventloop.createDatagramChannel((DatagramSocketSettings)this.datagramSocketSettings, null, (InetSocketAddress)this.dnsServerAddress);
            return AsyncUdpSocketNio.connect((Eventloop)this.eventloop, (DatagramChannel)channel).map(s -> {
                if (this.socketInspector != null) {
                    this.socketInspector.onCreate(s);
                    s.setInspector(this.socketInspector);
                }
                this.socket = s;
                return this.socket;
            });
        }
        catch (IOException e) {
            this.logger.error("UDP socket creation failed.", (Throwable)e);
            return Promise.ofException((Exception)e);
        }
    }

    @Override
    public Promise<DnsResponse> resolve(DnsQuery query) {
        DnsResponse fromQuery;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if ((fromQuery = AsyncDnsClient.resolveFromQuery(query)) != null) {
            this.logger.trace("{} already contained an IP address within itself", (Object)query);
            return Promise.of((Object)fromQuery);
        }
        int labelSize = 0;
        String domainName = query.getDomainName();
        for (int i = 0; i < domainName.length(); ++i) {
            if (domainName.charAt(i) == '.') {
                labelSize = 0;
                continue;
            }
            if (++labelSize <= 63) continue;
            return Promise.ofException((Exception)new IllegalArgumentException("Label size cannot exceed 63 octets"));
        }
        return this.getSocket().then(socket -> {
            this.logger.trace("Resolving {} with DNS server {}", (Object)query, (Object)this.dnsServerAddress);
            DnsTransaction transaction = DnsTransaction.of(DnsProtocol.generateTransactionId(), query);
            SettablePromise promise = new SettablePromise();
            this.transactions.put(transaction, (SettablePromise<DnsResponse>)promise);
            ByteBuf payload = DnsProtocol.createDnsQueryPayload(transaction);
            if (this.inspector != null) {
                this.inspector.onDnsQuery(query, payload);
            }
            socket.send(UdpPacket.of((ByteBuf)payload, (InetSocketAddress)this.dnsServerAddress));
            socket.receive().whenResult(packet -> {
                try {
                    DnsResponse queryResult = DnsProtocol.readDnsResponse(packet.getBuf());
                    SettablePromise<DnsResponse> cb = this.transactions.remove(queryResult.getTransaction());
                    if (cb == null) {
                        this.logger.warn("Received a DNS response that had no listener (most likely because it timed out) : {}", (Object)queryResult);
                        return;
                    }
                    if (queryResult.isSuccessful()) {
                        cb.set((Object)queryResult);
                    } else {
                        cb.setException((Exception)new DnsQueryException(queryResult));
                    }
                    this.closeIfDone();
                }
                catch (MalformedDataException e) {
                    this.logger.warn("Received a UDP packet than cannot be decoded as a DNS server response.", (Throwable)e);
                }
                finally {
                    packet.recycle();
                }
            });
            return Promises.timeout((Duration)this.timeout, (Promise)promise).then(queryResult -> {
                if (this.inspector != null) {
                    this.inspector.onDnsQueryResult(query, (DnsResponse)queryResult);
                }
                this.logger.trace("DNS query {} resolved as {}", (Object)query, (Object)queryResult.getRecord());
                return Promise.of((Object)queryResult);
            }, e -> {
                if (e instanceof AsyncTimeoutException) {
                    if (this.inspector != null) {
                        this.inspector.onDnsQueryExpiration(query);
                    }
                    this.logger.trace("{} timed out", (Object)query);
                    e = new DnsQueryException(DnsResponse.ofFailure(transaction, DnsProtocol.ResponseErrorCode.TIMED_OUT));
                    this.transactions.remove(transaction);
                    this.closeIfDone();
                } else if (this.inspector != null) {
                    this.inspector.onDnsQueryError(query, (Exception)e);
                }
                return Promise.ofException((Exception)e);
            });
        });
    }

    private void closeIfDone() {
        if (!this.transactions.isEmpty()) {
            return;
        }
        this.logger.trace("All queries are completed, closing UDP socket");
        this.close();
    }

    @JmxAttribute
    @Nullable
    public AsyncUdpSocketNio.JmxInspector getSocketStats() {
        return (AsyncUdpSocketNio.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketInspector, AsyncUdpSocketNio.JmxInspector.class);
    }

    @JmxAttribute(name="")
    @Nullable
    public JmxInspector getStats() {
        return (JmxInspector)BaseInspector.lookup((BaseInspector)this.inspector, JmxInspector.class);
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onDnsQuery(DnsQuery var1, ByteBuf var2);

        public void onDnsQueryResult(DnsQuery var1, DnsResponse var2);

        public void onDnsQueryError(DnsQuery var1, Exception var2);

        public void onDnsQueryExpiration(DnsQuery var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats queries = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats failedQueries = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats expirations = EventStats.create((Duration)SMOOTHING_WINDOW);

        @Override
        public void onDnsQuery(DnsQuery query, ByteBuf payload) {
            this.queries.recordEvent();
        }

        @Override
        public void onDnsQueryResult(DnsQuery query, DnsResponse result) {
            if (!result.isSuccessful()) {
                this.failedQueries.recordEvent();
            }
        }

        @Override
        public void onDnsQueryError(DnsQuery query, Exception e) {
            this.failedQueries.recordEvent();
        }

        @Override
        public void onDnsQueryExpiration(DnsQuery query) {
            this.expirations.recordEvent();
        }

        @JmxAttribute
        public EventStats getQueries() {
            return this.queries;
        }

        @JmxAttribute
        public EventStats getFailedQueries() {
            return this.failedQueries;
        }

        @JmxAttribute
        public EventStats getExpirations() {
            return this.expirations;
        }
    }
}

