/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns.protocol;

import io.activej.common.Checks;
import java.net.InetAddress;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class DnsResourceRecord {
    private final InetAddress[] ips;
    private final int minTtl;

    private DnsResourceRecord(InetAddress[] ips, int minTtl) {
        this.ips = ips;
        this.minTtl = minTtl;
    }

    public static DnsResourceRecord of(InetAddress[] ips, int minTtl) {
        Checks.checkArgument((ips.length > 0 ? 1 : 0) != 0, (Object)"Cannot create DNS record with no data");
        return new DnsResourceRecord(ips, minTtl);
    }

    public InetAddress[] getIps() {
        return this.ips;
    }

    public int getMinTtl() {
        return this.minTtl;
    }

    public String toString() {
        return "DnsResourceRecord{ips=" + Arrays.toString(this.ips) + ", minTtl=" + this.minTtl + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsResourceRecord that = (DnsResourceRecord)o;
        return this.minTtl == that.minTtl && Arrays.equals(this.ips, that.ips);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.ips) + this.minTtl;
    }
}

