/*
 * Decompiled with CFR 0.152.
 */
package io.activej.dns.protocol;

import io.activej.common.Checks;
import io.activej.dns.protocol.DnsProtocol;
import io.activej.dns.protocol.DnsResourceRecord;
import io.activej.dns.protocol.DnsTransaction;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class DnsResponse {
    private final DnsTransaction transaction;
    @Nullable
    private final DnsResourceRecord record;
    private final DnsProtocol.ResponseErrorCode errorCode;

    private DnsResponse(DnsTransaction transaction, @Nullable DnsResourceRecord record, DnsProtocol.ResponseErrorCode errorCode) {
        this.transaction = transaction;
        this.errorCode = errorCode;
        this.record = record;
    }

    public static DnsResponse of(DnsTransaction transactionId, DnsResourceRecord record) {
        return new DnsResponse(transactionId, record, DnsProtocol.ResponseErrorCode.NO_ERROR);
    }

    public static DnsResponse ofFailure(DnsTransaction transactionId, DnsProtocol.ResponseErrorCode errorCode) {
        Checks.checkArgument((errorCode != DnsProtocol.ResponseErrorCode.NO_ERROR ? 1 : 0) != 0, (Object)"Creating failure DNS query response with NO_ERROR error code");
        return new DnsResponse(transactionId, null, errorCode);
    }

    public boolean isSuccessful() {
        return this.record != null;
    }

    public DnsTransaction getTransaction() {
        return this.transaction;
    }

    public DnsProtocol.ResponseErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public DnsResourceRecord getRecord() {
        return this.record;
    }

    public String toString() {
        return "DnsResponse{transaction=" + this.transaction + ", record=" + this.record + ", errorCode=" + (Object)((Object)this.errorCode) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsResponse that = (DnsResponse)o;
        return this.transaction.equals(that.transaction) && Objects.equals(this.record, that.record) && this.errorCode == that.errorCode;
    }

    public int hashCode() {
        return 31 * (31 * this.transaction.hashCode() + (this.record != null ? this.record.hashCode() : 0)) + this.errorCode.hashCode();
    }
}

