/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.Checks;
import io.activej.http.HttpClientConnection;

final class AddressLinkedList {
    private static final boolean CHECK = Checks.isEnabled(AddressLinkedList.class);
    private HttpClientConnection first;
    private HttpClientConnection last;

    AddressLinkedList() {
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public HttpClientConnection removeLastNode() {
        if (this.last == null) {
            return null;
        }
        HttpClientConnection node = this.last;
        this.last = node.addressPrev;
        if (node.addressPrev != null) {
            node.addressPrev.addressNext = node.addressNext;
        } else {
            assert (this.first == node);
            this.first = node.addressNext;
        }
        node.addressPrev = null;
        node.addressNext = null;
        return node;
    }

    public void addLastNode(HttpClientConnection node) {
        if (CHECK) {
            Checks.checkArgument((node.addressPrev == null && node.addressNext == null ? 1 : 0) != 0);
        }
        if (this.last != null) {
            assert (this.last.addressNext == null);
            this.last.addressNext = node;
            node.addressPrev = this.last;
        } else {
            assert (this.first == null);
            this.first = node;
        }
        this.last = node;
    }

    public void removeNode(HttpClientConnection node) {
        if (node.addressPrev != null) {
            node.addressPrev.addressNext = node.addressNext;
        } else {
            assert (this.first == node);
            this.first = node.addressNext;
        }
        if (node.addressNext != null) {
            node.addressNext.addressPrev = node.addressPrev;
        } else {
            assert (this.last == node);
            this.last = node.addressPrev;
        }
        node.addressPrev = null;
        node.addressNext = null;
    }

    public int size() {
        int count = 0;
        HttpClientConnection connection = this.first;
        while (connection != null) {
            ++count;
            connection = connection.addressNext;
        }
        return count;
    }
}

