/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.exception.AsyncTimeoutException;
import io.activej.async.service.EventloopService;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.dns.AsyncDnsClient;
import io.activej.dns.RemoteAsyncDnsClient;
import io.activej.dns.protocol.DnsQueryException;
import io.activej.dns.protocol.DnsResponse;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanWithStats;
import io.activej.eventloop.net.SocketSettings;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.http.AddressLinkedList;
import io.activej.http.ConnectionsLinkedList;
import io.activej.http.HttpClientConnection;
import io.activej.http.HttpException;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.IAsyncHttpClient;
import io.activej.http.IAsyncWebSocketClient;
import io.activej.http.MalformedHttpException;
import io.activej.http.Protocol;
import io.activej.http.WebSocket;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.MBeanFormat;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.net.socket.tcp.AsyncTcpSocketNio;
import io.activej.net.socket.tcp.AsyncTcpSocketSsl;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncHttpClient
implements IAsyncHttpClient,
IAsyncWebSocketClient,
EventloopService,
EventloopJmxBeanWithStats,
WithInitializer<AsyncHttpClient> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private static final boolean CHECK = Checks.isEnabled(AsyncHttpClient.class);
    public static final SocketSettings DEFAULT_SOCKET_SETTINGS = SocketSettings.createDefault();
    public static final Duration CONNECT_TIMEOUT = ApplicationSettings.getDuration(AsyncHttpClient.class, (String)"connectTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT = ApplicationSettings.getDuration(AsyncHttpClient.class, (String)"readWriteTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(AsyncHttpClient.class, (String)"readWriteTimeout_Shutdown", (Duration)Duration.ofSeconds(3L));
    public static final Duration KEEP_ALIVE_TIMEOUT = ApplicationSettings.getDuration(AsyncHttpClient.class, (String)"keepAliveTimeout", (Duration)Duration.ZERO);
    public static final MemSize MAX_BODY_SIZE = ApplicationSettings.getMemSize(AsyncHttpClient.class, (String)"maxBodySize", (MemSize)MemSize.ZERO);
    public static final MemSize MAX_WEB_SOCKET_MESSAGE_SIZE = ApplicationSettings.getMemSize(AsyncHttpClient.class, (String)"maxWebSocketMessageSize", (MemSize)MemSize.megabytes((long)1L));
    public static final int MAX_KEEP_ALIVE_REQUESTS = ApplicationSettings.getInt(AsyncHttpClient.class, (String)"maxKeepAliveRequests", (int)0);
    @NotNull
    private final Eventloop eventloop;
    @NotNull
    private AsyncDnsClient asyncDnsClient;
    @NotNull
    private SocketSettings socketSettings = DEFAULT_SOCKET_SETTINGS;
    final HashMap<InetSocketAddress, AddressLinkedList> addresses = new HashMap();
    final ConnectionsLinkedList poolKeepAlive = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolReadWrite = new ConnectionsLinkedList();
    private int poolKeepAliveExpired;
    private int poolReadWriteExpired;
    @Nullable
    private ScheduledRunnable expiredConnectionsCheck;
    int connectTimeoutMillis = (int)CONNECT_TIMEOUT.toMillis();
    int readWriteTimeoutMillis = (int)READ_WRITE_TIMEOUT.toMillis();
    int readWriteTimeoutMillisShutdown = (int)READ_WRITE_TIMEOUT_SHUTDOWN.toMillis();
    int keepAliveTimeoutMillis = (int)KEEP_ALIVE_TIMEOUT.toMillis();
    int maxBodySize = MAX_BODY_SIZE.toInt();
    int maxWebSocketMessageSize = MAX_WEB_SOCKET_MESSAGE_SIZE.toInt();
    int maxKeepAliveRequests = MAX_KEEP_ALIVE_REQUESTS;
    private SSLContext sslContext;
    private Executor sslExecutor;
    @Nullable
    private AsyncTcpSocketNio.Inspector socketInspector;
    @Nullable
    private AsyncTcpSocketNio.Inspector socketSslInspector;
    @Nullable
    Inspector inspector;
    private int inetAddressIdx = 0;
    @Nullable
    private SettablePromise<Void> closePromise;

    private AsyncHttpClient(@NotNull Eventloop eventloop, @NotNull AsyncDnsClient asyncDnsClient) {
        this.eventloop = eventloop;
        this.asyncDnsClient = asyncDnsClient;
    }

    public static AsyncHttpClient create(@NotNull Eventloop eventloop) {
        RemoteAsyncDnsClient defaultDnsClient = RemoteAsyncDnsClient.create(eventloop);
        return new AsyncHttpClient(eventloop, defaultDnsClient);
    }

    public AsyncHttpClient withSocketSettings(@NotNull SocketSettings socketSettings) {
        this.socketSettings = socketSettings;
        return this;
    }

    public AsyncHttpClient withDnsClient(@NotNull AsyncDnsClient asyncDnsClient) {
        this.asyncDnsClient = asyncDnsClient;
        return this;
    }

    public AsyncHttpClient withSslEnabled(@NotNull SSLContext sslContext, @NotNull Executor sslExecutor) {
        this.sslContext = sslContext;
        this.sslExecutor = sslExecutor;
        return this;
    }

    public AsyncHttpClient withKeepAliveTimeout(@NotNull Duration keepAliveTime) {
        this.keepAliveTimeoutMillis = (int)keepAliveTime.toMillis();
        return this;
    }

    public AsyncHttpClient withNoKeepAlive() {
        return this.withKeepAliveTimeout(Duration.ZERO);
    }

    public AsyncHttpClient withMaxKeepAliveRequests(int maxKeepAliveRequests) {
        Checks.checkArgument((maxKeepAliveRequests >= 0 ? 1 : 0) != 0, (Object)"Maximum number of requests per keep-alive connection should not be less than zero");
        this.maxKeepAliveRequests = maxKeepAliveRequests;
        return this;
    }

    public AsyncHttpClient withReadWriteTimeout(@NotNull Duration readWriteTimeout) {
        this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
        return this;
    }

    public AsyncHttpClient withReadWriteTimeout(@NotNull Duration readWriteTimeout, @NotNull Duration readWriteTimeoutShutdown) {
        this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
        this.readWriteTimeoutMillisShutdown = (int)readWriteTimeoutShutdown.toMillis();
        return this;
    }

    public AsyncHttpClient withConnectTimeout(@NotNull Duration connectTimeout) {
        this.connectTimeoutMillis = (int)connectTimeout.toMillis();
        return this;
    }

    public AsyncHttpClient withMaxBodySize(MemSize maxBodySize) {
        return this.withMaxBodySize(maxBodySize.toInt());
    }

    public AsyncHttpClient withMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize != 0 ? maxBodySize : Integer.MAX_VALUE;
        return this;
    }

    public AsyncHttpClient withMaxWebSocketMessageSize(MemSize maxWebSocketMessageSize) {
        this.maxWebSocketMessageSize = maxWebSocketMessageSize.toInt();
        return this;
    }

    public AsyncHttpClient withInspector(Inspector inspector) {
        this.inspector = inspector;
        return this;
    }

    public AsyncHttpClient withSocketInspector(AsyncTcpSocketNio.Inspector socketInspector) {
        this.socketInspector = socketInspector;
        return this;
    }

    public AsyncHttpClient withSocketSslInspector(AsyncTcpSocketNio.Inspector socketSslInspector) {
        this.socketSslInspector = socketSslInspector;
        return this;
    }

    private void scheduleExpiredConnectionsCheck() {
        assert (this.expiredConnectionsCheck == null);
        this.expiredConnectionsCheck = this.eventloop.delayBackground(1000L, () -> {
            boolean isClosing;
            this.expiredConnectionsCheck = null;
            this.poolKeepAliveExpired += this.poolKeepAlive.closeExpiredConnections(this.eventloop.currentTimeMillis() - (long)this.keepAliveTimeoutMillis);
            boolean bl = isClosing = this.closePromise != null;
            if (this.readWriteTimeoutMillis != 0 || isClosing) {
                this.poolReadWriteExpired += this.poolReadWrite.closeExpiredConnections(this.eventloop.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown), new AsyncTimeoutException("Read timeout"));
            }
            if (this.getConnectionsCount() != 0) {
                this.scheduleExpiredConnectionsCheck();
                if (isClosing) {
                    logger.info("...Waiting for {}", (Object)this);
                }
            }
        });
    }

    @Nullable
    private HttpClientConnection takeKeepAliveConnection(InetSocketAddress address) {
        AddressLinkedList addresses = this.addresses.get(address);
        if (addresses == null) {
            return null;
        }
        HttpClientConnection connection = addresses.removeLastNode();
        assert (connection != null);
        assert (connection.pool == this.poolKeepAlive);
        assert (connection.remoteAddress.equals(address));
        connection.pool.removeNode(connection);
        if (addresses.isEmpty()) {
            this.addresses.remove(address);
        }
        return connection;
    }

    void returnToKeepAlivePool(HttpClientConnection connection) {
        assert (!connection.isClosed());
        AddressLinkedList addresses = this.addresses.get(connection.remoteAddress);
        if (addresses == null) {
            addresses = new AddressLinkedList();
            this.addresses.put(connection.remoteAddress, addresses);
        }
        addresses.addLastNode(connection);
        connection.switchPool(this.poolKeepAlive);
        if (this.expiredConnectionsCheck == null) {
            this.scheduleExpiredConnectionsCheck();
        }
    }

    @Override
    public Promise<HttpResponse> request(HttpRequest request) {
        if (CHECK) {
            Checks.checkArgument((Object)((Object)request.getProtocol()), protocol -> protocol == Protocol.HTTP || protocol == Protocol.HTTPS);
        }
        return this.doRequest(request, false);
    }

    @Override
    public Promise<WebSocket> webSocketRequest(HttpRequest request) {
        Checks.checkState((boolean)WebSocket.ENABLED, (Object)"Web sockets are disabled by application settings");
        Checks.checkArgument((request.getProtocol() == Protocol.WS || request.getProtocol() == Protocol.WSS ? 1 : 0) != 0, (Object)"Wrong protocol");
        Checks.checkArgument((request.body == null && request.bodyStream == null ? 1 : 0) != 0, (Object)"No body should be present");
        return this.doRequest(request, true);
    }

    @NotNull
    private Promise<?> doRequest(HttpRequest request, boolean isWebSocket) {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        if (this.inspector != null) {
            this.inspector.onRequest(request);
        }
        String host = request.getUrl().getHost();
        assert (host != null);
        return this.asyncDnsClient.resolve4(host).then(dnsResponse -> {
            if (this.inspector != null) {
                this.inspector.onResolve(request, (DnsResponse)dnsResponse);
            }
            if (dnsResponse.isSuccessful()) {
                return this.doSend(request, dnsResponse.getRecord().getIps(), isWebSocket);
            }
            request.recycleBody();
            return Promise.ofException((Exception)new HttpException(new DnsQueryException((DnsResponse)dnsResponse)));
        }, e -> {
            if (this.inspector != null) {
                this.inspector.onResolveError(request, (Exception)e);
            }
            request.recycleBody();
            return Promise.ofException((Exception)HttpUtils.translateToHttpException(e));
        });
    }

    private Promise<?> doSend(HttpRequest request, InetAddress[] inetAddresses, boolean isWebSocket) {
        InetAddress inetAddress;
        InetSocketAddress address;
        HttpClientConnection keepAliveConnection;
        if ((keepAliveConnection = this.takeKeepAliveConnection(address = new InetSocketAddress(inetAddress = inetAddresses[(this.inetAddressIdx++ & Integer.MAX_VALUE) % inetAddresses.length], request.getUrl().getPort()))) != null) {
            if (isWebSocket) {
                return keepAliveConnection.sendWebSocketRequest(request);
            }
            return keepAliveConnection.send(request);
        }
        boolean isSecure = request.getProtocol().isSecure();
        if (isSecure && this.sslContext == null) {
            request.recycleBody();
            throw new IllegalArgumentException("Cannot send Secure Request without SSL enabled");
        }
        if (this.inspector != null) {
            this.inspector.onConnecting(request, address);
        }
        return AsyncTcpSocketNio.connect((InetSocketAddress)address, (long)this.connectTimeoutMillis, (SocketSettings)this.socketSettings).then(asyncTcpSocketImpl -> {
            AsyncTcpSocketNio.Inspector socketInspector;
            AsyncTcpSocketNio.Inspector inspector = socketInspector = isSecure ? this.socketInspector : this.socketSslInspector;
            if (socketInspector != null) {
                socketInspector.onConnect(asyncTcpSocketImpl);
                asyncTcpSocketImpl.setInspector(socketInspector);
            }
            String host = request.getUrl().getHost();
            assert (host != null);
            AsyncTcpSocketNio asyncTcpSocket = isSecure ? AsyncTcpSocketSsl.wrapClientSocket((AsyncTcpSocket)asyncTcpSocketImpl, (String)host, (int)request.getUrl().getPort(), (SSLContext)this.sslContext, (Executor)this.sslExecutor) : asyncTcpSocketImpl;
            HttpClientConnection connection = new HttpClientConnection(this.eventloop, this, (AsyncTcpSocket)asyncTcpSocket, address);
            if (this.inspector != null) {
                this.inspector.onConnect(request, connection);
            }
            if (this.expiredConnectionsCheck == null) {
                this.scheduleExpiredConnectionsCheck();
            }
            if (isWebSocket) {
                return connection.sendWebSocketRequest(request);
            }
            return connection.send(request);
        }, e -> {
            if (this.inspector != null) {
                this.inspector.onConnectError(request, address, (Exception)e);
            }
            request.recycleBody();
            return Promise.ofException((Exception)HttpUtils.translateToHttpException(e));
        });
    }

    @NotNull
    public Eventloop getEventloop() {
        return this.eventloop;
    }

    @NotNull
    public Promise<Void> start() {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        return Promise.complete();
    }

    public void onConnectionClosed() {
        if (this.getConnectionsCount() == 0 && this.closePromise != null) {
            this.closePromise.set(null);
            this.closePromise = null;
        }
    }

    @NotNull
    public Promise<Void> stop() {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        SettablePromise promise = new SettablePromise();
        this.poolKeepAlive.closeAllConnections();
        assert (this.addresses.isEmpty());
        this.keepAliveTimeoutMillis = 0;
        if (this.getConnectionsCount() == 0) {
            assert (this.poolReadWrite.isEmpty());
            promise.set(null);
        } else {
            this.closePromise = promise;
            logger.info("Waiting for {}", (Object)this);
        }
        return promise;
    }

    @JmxAttribute(description="current number of connections", reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsCount() {
        return this.poolKeepAlive.size() + this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveCount() {
        return this.poolKeepAlive.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteCount() {
        return this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveExpired() {
        return this.poolKeepAliveExpired;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteExpired() {
        return this.poolReadWriteExpired;
    }

    @JmxOperation(description="number of connections per address")
    public String getAddressConnections() {
        if (this.addresses.isEmpty()) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("SocketAddress,ConnectionsCount");
        for (Map.Entry<InetSocketAddress, AddressLinkedList> entry : this.addresses.entrySet()) {
            InetSocketAddress address = entry.getKey();
            AddressLinkedList connections = entry.getValue();
            result.add(address + ", " + connections.size());
        }
        return MBeanFormat.formatListAsMultilineString(result);
    }

    @JmxAttribute
    @Nullable
    public AsyncTcpSocketNio.JmxInspector getSocketStats() {
        return (AsyncTcpSocketNio.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketInspector, AsyncTcpSocketNio.JmxInspector.class);
    }

    @JmxAttribute
    @Nullable
    public AsyncTcpSocketNio.JmxInspector getSocketStatsSsl() {
        return (AsyncTcpSocketNio.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketSslInspector, AsyncTcpSocketNio.JmxInspector.class);
    }

    @JmxAttribute(name="")
    @Nullable
    public JmxInspector getStats() {
        return (JmxInspector)BaseInspector.lookup((BaseInspector)this.inspector, JmxInspector.class);
    }

    public String toString() {
        return "AsyncHttpClient{read/write:" + this.poolReadWrite.size() + " keep-alive:" + this.poolKeepAlive.size() + "}";
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onRequest(HttpRequest var1);

        public void onResolve(HttpRequest var1, DnsResponse var2);

        public void onResolveError(HttpRequest var1, Exception var2);

        default public void onConnecting(HttpRequest request, InetSocketAddress address) {
        }

        public void onConnect(HttpRequest var1, HttpClientConnection var2);

        public void onConnectError(HttpRequest var1, InetSocketAddress var2, Exception var3);

        public void onHttpResponse(HttpResponse var1);

        public void onHttpError(HttpClientConnection var1, Exception var2);

        default public void onMalformedHttpResponse(HttpClientConnection connection, MalformedHttpException e, byte[] malformedResponseBytes) {
        }

        public void onDisconnect(HttpClientConnection var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats totalRequests = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats resolveErrors = ExceptionStats.create();
        private final EventStats connected = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats connectErrors = ExceptionStats.create();
        private long responses;
        private final EventStats httpTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats httpErrors = ExceptionStats.create();
        private final ExceptionStats malformedHttpExceptions = ExceptionStats.create();
        private long responsesErrors;
        private final EventStats sslErrors = EventStats.create((Duration)SMOOTHING_WINDOW);
        private long activeConnections;
        private int connecting;

        @Override
        public void onRequest(HttpRequest request) {
            this.totalRequests.recordEvent();
        }

        @Override
        public void onResolve(HttpRequest request, DnsResponse dnsResponse) {
        }

        @Override
        public void onResolveError(HttpRequest request, Exception e) {
            this.resolveErrors.recordException((Throwable)e, (Object)request.getUrl().getHost());
        }

        @Override
        public void onConnecting(HttpRequest request, InetSocketAddress address) {
            ++this.connecting;
        }

        @Override
        public void onConnect(HttpRequest request, HttpClientConnection connection) {
            ++this.activeConnections;
            --this.connecting;
            this.connected.recordEvent();
        }

        @Override
        public void onConnectError(HttpRequest request, InetSocketAddress address, Exception e) {
            --this.connecting;
            this.connectErrors.recordException((Throwable)e, (Object)request.getUrl().getHost());
        }

        @Override
        public void onHttpResponse(HttpResponse response) {
            ++this.responses;
        }

        @Override
        public void onHttpError(HttpClientConnection connection, Exception e) {
            if (e instanceof AsyncTimeoutException) {
                this.httpTimeouts.recordEvent();
                return;
            }
            this.httpErrors.recordException((Throwable)e);
            if (e instanceof SSLException) {
                this.sslErrors.recordEvent();
            }
            if (!connection.isKeepAlive()) {
                ++this.responsesErrors;
            }
        }

        @Override
        public void onMalformedHttpResponse(HttpClientConnection connection, MalformedHttpException e, byte[] malformedResponseBytes) {
            String responseString = new String(malformedResponseBytes, 0, malformedResponseBytes.length, StandardCharsets.ISO_8859_1);
            this.malformedHttpExceptions.recordException((Throwable)e, (Object)responseString);
        }

        @Override
        public void onDisconnect(HttpClientConnection connection) {
            --this.activeConnections;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"}, description="all requests that were sent (both successful and failed)")
        public EventStats getTotalRequests() {
            return this.totalRequests;
        }

        @JmxAttribute
        public ExceptionStats getResolveErrors() {
            return this.resolveErrors;
        }

        @JmxAttribute
        public ExceptionStats getConnectErrors() {
            return this.connectErrors;
        }

        @JmxAttribute(description="number of \"open connection\" events)")
        public EventStats getConnected() {
            return this.connected;
        }

        @JmxAttribute
        public EventStats getHttpTimeouts() {
            return this.httpTimeouts;
        }

        @JmxAttribute
        public ExceptionStats getHttpErrors() {
            return this.httpErrors;
        }

        @JmxAttribute
        public ExceptionStats getMalformedHttpExceptions() {
            return this.malformedHttpExceptions;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public long getActiveRequests() {
            return this.totalRequests.getTotalCount() - (this.httpTimeouts.getTotalCount() + (long)this.resolveErrors.getTotal() + (long)this.connectErrors.getTotal() + this.responsesErrors + this.responses);
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public long getTotalResponses() {
            return this.responses;
        }

        @JmxAttribute
        public EventStats getSslErrors() {
            return this.sslErrors;
        }

        @JmxAttribute
        public long getActiveConnections() {
            return this.activeConnections;
        }

        @JmxAttribute(description="number of \"currently connecting\" sockets)")
        public int getConnecting() {
            return this.connecting;
        }
    }
}

