/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.exception.AsyncTimeoutException;
import io.activej.common.ApplicationSettings;
import io.activej.common.MemSize;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.http.AsyncServlet;
import io.activej.http.ConnectionsLinkedList;
import io.activej.http.HttpExceptionFormatter;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpServerConnection;
import io.activej.http.MalformedHttpException;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.net.AbstractServer;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncHttpServer
extends AbstractServer<AsyncHttpServer> {
    public static final Duration READ_WRITE_TIMEOUT = ApplicationSettings.getDuration(AsyncHttpServer.class, (String)"readWriteTimeout", (Duration)Duration.ZERO);
    public static final Duration READ_WRITE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(AsyncHttpServer.class, (String)"readWriteTimeout_Shutdown", (Duration)Duration.ofSeconds(3L));
    public static final Duration SERVE_TIMEOUT_SHUTDOWN = ApplicationSettings.getDuration(AsyncHttpServer.class, (String)"serveTimeout_Shutdown", (Duration)Duration.ofSeconds(0L));
    public static final Duration KEEP_ALIVE_TIMEOUT = ApplicationSettings.getDuration(AsyncHttpServer.class, (String)"keepAliveTimeout", (Duration)Duration.ofSeconds(30L));
    public static final MemSize MAX_BODY_SIZE = ApplicationSettings.getMemSize(AsyncHttpServer.class, (String)"maxBodySize", (MemSize)MemSize.ZERO);
    public static final MemSize MAX_WEB_SOCKET_MESSAGE_SIZE = ApplicationSettings.getMemSize(AsyncHttpServer.class, (String)"maxWebSocketMessageSize", (MemSize)MemSize.megabytes((long)1L));
    public static final int MAX_KEEP_ALIVE_REQUESTS = ApplicationSettings.getInt(AsyncHttpServer.class, (String)"maxKeepAliveRequests", (int)0);
    @NotNull
    private final AsyncServlet servlet;
    @NotNull
    private HttpExceptionFormatter errorFormatter = HttpExceptionFormatter.COMMON_FORMATTER;
    int readWriteTimeoutMillis = (int)READ_WRITE_TIMEOUT.toMillis();
    int readWriteTimeoutMillisShutdown = (int)READ_WRITE_TIMEOUT_SHUTDOWN.toMillis();
    int serveTimeoutMillisShutdown = (int)SERVE_TIMEOUT_SHUTDOWN.toMillis();
    int keepAliveTimeoutMillis = (int)KEEP_ALIVE_TIMEOUT.toMillis();
    int maxBodySize = MAX_BODY_SIZE.toInt();
    int maxWebSocketMessageSize = MAX_WEB_SOCKET_MESSAGE_SIZE.toInt();
    int maxKeepAliveRequests = MAX_KEEP_ALIVE_REQUESTS;
    final ConnectionsLinkedList poolNew = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolReadWrite = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolServing = new ConnectionsLinkedList();
    final ConnectionsLinkedList poolKeepAlive = new ConnectionsLinkedList();
    private int poolKeepAliveExpired;
    private int poolReadWriteExpired;
    @Nullable
    private ScheduledRunnable expiredConnectionsCheck;
    @Nullable
    Inspector inspector;
    private final SettablePromise<@Nullable Void> closeNotification = new SettablePromise();
    @Nullable
    private SettablePromise<Void> closeCallback;

    private AsyncHttpServer(@NotNull Eventloop eventloop, @NotNull AsyncServlet servlet) {
        super(eventloop);
        this.servlet = servlet;
    }

    public static AsyncHttpServer create(@NotNull Eventloop eventloop, @NotNull AsyncServlet servlet) {
        return new AsyncHttpServer(eventloop, servlet);
    }

    public AsyncHttpServer withKeepAliveTimeout(@NotNull Duration keepAliveTime) {
        this.keepAliveTimeoutMillis = (int)keepAliveTime.toMillis();
        return this;
    }

    public AsyncHttpServer withMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
        return this;
    }

    public AsyncHttpServer withNoKeepAlive() {
        return this.withKeepAliveTimeout(Duration.ZERO);
    }

    public AsyncHttpServer withReadWriteTimeout(@NotNull Duration readWriteTimeout) {
        this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
        return this;
    }

    public AsyncHttpServer withReadWriteTimeout(@NotNull Duration readWriteTimeout, @NotNull Duration readWriteTimeoutShutdown) {
        this.readWriteTimeoutMillis = (int)readWriteTimeout.toMillis();
        this.readWriteTimeoutMillisShutdown = (int)readWriteTimeoutShutdown.toMillis();
        return this;
    }

    public AsyncHttpServer withServeTimeoutShutdown(@NotNull Duration serveTimeoutShutdown) {
        this.serveTimeoutMillisShutdown = (int)serveTimeoutShutdown.toMillis();
        return this;
    }

    public AsyncHttpServer withMaxBodySize(MemSize maxBodySize) {
        return this.withMaxBodySize(maxBodySize.toInt());
    }

    public AsyncHttpServer withMaxBodySize(int maxBodySize) {
        this.maxBodySize = maxBodySize;
        return this;
    }

    public AsyncHttpServer withMaxWebSocketMessageSize(MemSize maxWebSocketMessageSize) {
        this.maxWebSocketMessageSize = maxWebSocketMessageSize.toInt();
        return this;
    }

    public AsyncHttpServer withHttpErrorFormatter(@NotNull HttpExceptionFormatter httpExceptionFormatter) {
        this.errorFormatter = httpExceptionFormatter;
        return this;
    }

    public AsyncHttpServer withInspector(Inspector inspector) {
        this.inspector = inspector;
        return this;
    }

    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeoutMillis);
    }

    public Duration getReadWriteTimeout() {
        return Duration.ofMillis(this.readWriteTimeoutMillis);
    }

    public Promise<Void> getCloseNotification() {
        return this.closeNotification;
    }

    private void scheduleExpiredConnectionsCheck() {
        assert (this.expiredConnectionsCheck == null);
        this.expiredConnectionsCheck = this.eventloop.delayBackground(1000L, () -> {
            boolean isClosing;
            this.expiredConnectionsCheck = null;
            boolean bl = isClosing = this.closeCallback != null;
            if (this.readWriteTimeoutMillis != 0 || isClosing) {
                this.poolReadWriteExpired += this.poolNew.closeExpiredConnections(this.eventloop.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown));
                this.poolReadWriteExpired += this.poolReadWrite.closeExpiredConnections(this.eventloop.currentTimeMillis() - (long)(!isClosing ? this.readWriteTimeoutMillis : this.readWriteTimeoutMillisShutdown), new AsyncTimeoutException("Read timeout"));
            }
            this.poolKeepAliveExpired += this.poolKeepAlive.closeExpiredConnections(this.eventloop.currentTimeMillis() - (long)this.keepAliveTimeoutMillis);
            if (this.getConnectionsCount() != 0) {
                this.scheduleExpiredConnectionsCheck();
                if (isClosing) {
                    this.logger.info("...Waiting for {}", (Object)this);
                }
            }
        });
    }

    protected void serve(AsyncTcpSocket socket, InetAddress remoteAddress) {
        if (this.expiredConnectionsCheck == null) {
            this.scheduleExpiredConnectionsCheck();
        }
        HttpServerConnection connection = new HttpServerConnection(this.eventloop, socket, remoteAddress, this, this.servlet);
        connection.serve();
    }

    void onConnectionClosed() {
        if (this.getConnectionsCount() == 0 && this.closeCallback != null) {
            this.closeCallback.set(null);
            this.closeCallback = null;
        }
    }

    protected void onClose(SettablePromise<@Nullable Void> cb) {
        this.closeNotification.set(null);
        this.poolKeepAlive.closeAllConnections();
        this.keepAliveTimeoutMillis = 0;
        if (this.getConnectionsCount() == 0) {
            cb.set(null);
        } else {
            if (!this.poolServing.isEmpty() && this.serveTimeoutMillisShutdown != 0) {
                this.eventloop.delayBackground((long)this.serveTimeoutMillisShutdown, this.poolServing::closeAllConnections);
            }
            this.closeCallback = cb;
            this.logger.info("Waiting for {}", (Object)this);
        }
    }

    private static String format(InetSocketAddress address, boolean ssl) {
        return (ssl ? "https://" : "http://") + ("0.0.0.0".equals(address.getHostName()) ? "localhost" : address.getHostName()) + (address.getPort() != (ssl ? 443 : 80) ? ":" + address.getPort() : "") + "/";
    }

    public List<String> getHttpAddresses() {
        return Stream.concat(this.listenAddresses.stream().map(address -> AsyncHttpServer.format(address, false)), this.sslListenAddresses.stream().map(address -> AsyncHttpServer.format(address, true))).collect(Collectors.toList());
    }

    @JmxAttribute(description="current number of connections", reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsCount() {
        return this.poolNew.size() + this.poolKeepAlive.size() + this.poolReadWrite.size() + this.poolServing.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsNewCount() {
        return this.poolNew.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteCount() {
        return this.poolReadWrite.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsServingCount() {
        return this.poolServing.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveCount() {
        return this.poolKeepAlive.size();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsKeepAliveExpired() {
        return this.poolKeepAliveExpired;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getConnectionsReadWriteExpired() {
        return this.poolReadWriteExpired;
    }

    HttpResponse formatHttpError(Exception e) {
        return this.errorFormatter.formatException(e);
    }

    @JmxAttribute(name="")
    @Nullable
    public JmxInspector getStats() {
        return (JmxInspector)BaseInspector.lookup((BaseInspector)this.inspector, JmxInspector.class);
    }

    public String toString() {
        return "AsyncHttpServer{new:" + this.poolNew.size() + " read/write:" + this.poolReadWrite.size() + " serving:" + this.poolServing.size() + " keep-alive:" + this.poolKeepAlive.size() + "}";
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onAccept(HttpServerConnection var1);

        public void onHttpRequest(HttpRequest var1);

        public void onHttpResponse(HttpRequest var1, HttpResponse var2);

        public void onServletException(HttpRequest var1, Exception var2);

        public void onHttpError(HttpServerConnection var1, Exception var2);

        default public void onMalformedHttpRequest(HttpServerConnection connection, MalformedHttpException e, byte[] malformedRequestBytes) {
        }

        public void onDisconnect(HttpServerConnection var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats totalConnections = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats totalRequests = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats totalResponses = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats httpTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats httpErrors = ExceptionStats.create();
        private final ExceptionStats malformedHttpExceptions = ExceptionStats.create();
        private final ExceptionStats servletExceptions = ExceptionStats.create();
        private long activeConnections;

        @Override
        public void onAccept(HttpServerConnection connection) {
            this.totalConnections.recordEvent();
            ++this.activeConnections;
        }

        @Override
        public void onHttpRequest(HttpRequest request) {
            this.totalRequests.recordEvent();
        }

        @Override
        public void onHttpResponse(HttpRequest request, HttpResponse httpResponse) {
            this.totalResponses.recordEvent();
        }

        @Override
        public void onServletException(HttpRequest request, Exception e) {
            this.servletExceptions.recordException((Throwable)e, (Object)request.toString());
        }

        @Override
        public void onHttpError(HttpServerConnection connection, Exception e) {
            if (e instanceof AsyncTimeoutException) {
                this.httpTimeouts.recordEvent();
            } else {
                this.httpErrors.recordException((Throwable)e);
            }
        }

        @Override
        public void onMalformedHttpRequest(HttpServerConnection connection, MalformedHttpException e, byte[] malformedRequestBytes) {
            String requestString = new String(malformedRequestBytes, 0, malformedRequestBytes.length, StandardCharsets.ISO_8859_1);
            this.malformedHttpExceptions.recordException((Throwable)e, (Object)requestString);
        }

        @Override
        public void onDisconnect(HttpServerConnection connection) {
            --this.activeConnections;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalConnections() {
            return this.totalConnections;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalRequests() {
            return this.totalRequests;
        }

        @JmxAttribute(extraSubAttributes={"totalCount"})
        public EventStats getTotalResponses() {
            return this.totalResponses;
        }

        @JmxAttribute
        public EventStats getHttpTimeouts() {
            return this.httpTimeouts;
        }

        @JmxAttribute(description="Number of requests which were invalid according to http protocol. Responses were not sent for this requests")
        public ExceptionStats getHttpErrors() {
            return this.httpErrors;
        }

        @JmxAttribute
        public ExceptionStats getMalformedHttpExceptions() {
            return this.malformedHttpExceptions;
        }

        @JmxAttribute(description="Number of requests which were valid according to http protocol, but application produced error during handling this request (responses with 4xx and 5xx HTTP status codes)")
        public ExceptionStats getServletExceptions() {
            return this.servletExceptions;
        }

        @JmxAttribute
        public long getActiveConnections() {
            return this.activeConnections;
        }
    }
}

