/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.function.AsyncBiPredicate;
import io.activej.http.AsyncServlet;
import io.activej.http.ContentTypes;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.promise.Promise;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class BasicAuth
implements AsyncServlet {
    public static final BiPredicate<String, String> SILLY = (login, pass) -> true;
    private static final String PREFIX = "Basic ";
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final AsyncServlet next;
    private final String challenge;
    private final AsyncBiPredicate<String, String> credentialsLookup;
    private UnaryOperator<HttpResponse> failureResponse = response -> response.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.PLAIN_TEXT_UTF_8)).withBody("Authentication is required".getBytes(StandardCharsets.UTF_8));

    public BasicAuth(AsyncServlet next, String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        this.next = next;
        this.credentialsLookup = credentialsLookup;
        this.challenge = "Basic realm=\"" + realm + "\", charset=\"UTF-8\"";
    }

    public BasicAuth withFailureResponse(UnaryOperator<HttpResponse> failureResponse) {
        this.failureResponse = failureResponse;
        return this;
    }

    public static Function<AsyncServlet, AsyncServlet> decorator(String realm, AsyncBiPredicate<String, String> credentialsLookup) {
        return next -> new BasicAuth((AsyncServlet)next, realm, credentialsLookup);
    }

    public static Function<AsyncServlet, AsyncServlet> decorator(String realm, AsyncBiPredicate<String, String> credentialsLookup, UnaryOperator<HttpResponse> failureResponse) {
        return next -> new BasicAuth((AsyncServlet)next, realm, credentialsLookup).withFailureResponse(failureResponse);
    }

    @NotNull
    public Promise<HttpResponse> serve(@NotNull HttpRequest request) throws HttpError {
        byte[] raw;
        String header = request.getHeader(HttpHeaders.AUTHORIZATION);
        if (header == null || !header.startsWith(PREFIX)) {
            return Promise.of((Object)((HttpResponse)this.failureResponse.apply(HttpResponse.unauthorized401(this.challenge))));
        }
        try {
            raw = DECODER.decode(header.substring(PREFIX.length()));
        }
        catch (IllegalArgumentException e) {
            throw HttpError.ofCode(400, "Base64: " + e.getMessage());
        }
        String[] authData = new String(raw, StandardCharsets.UTF_8).split(":", 2);
        if (authData.length != 2) {
            throw HttpError.ofCode(400, "No ':' separator");
        }
        return this.credentialsLookup.test((Object)authData[0], (Object)authData[1]).thenIfElse(ok -> ok, $ -> {
            request.attach(new BasicAuthCredentials(authData[0], authData[1]));
            return this.next.serveAsync(request);
        }, $ -> Promise.of((Object)((HttpResponse)this.failureResponse.apply(HttpResponse.unauthorized401(this.challenge)))));
    }

    public static BiPredicate<String, String> lookupFrom(Map<String, String> credentials) {
        return (login, pass) -> pass.equals(credentials.get(login));
    }

    public static final class BasicAuthCredentials {
        private final String username;
        private final String password;

        public BasicAuthCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

