/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.HttpDate;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpCookie {
    private static final byte[] EXPIRES = ByteBufStrings.encodeAscii((String)"Expires");
    private static final int EXPIRES_HC = 433574931;
    private static final byte[] MAX_AGE = ByteBufStrings.encodeAscii((String)"Max-Age");
    private static final int MAX_AGE_HC = -1709216267;
    private static final byte[] DOMAIN = ByteBufStrings.encodeAscii((String)"Domain");
    private static final int DOMAIN_HC = -438693883;
    private static final byte[] PATH = ByteBufStrings.encodeAscii((String)"Path");
    private static final int PATH_HC = 4357030;
    private static final byte[] HTTPONLY = ByteBufStrings.encodeAscii((String)"HttpOnly");
    private static final int SECURE_HC = -18770248;
    private static final byte[] SECURE = ByteBufStrings.encodeAscii((String)"Secure");
    private static final int HTTP_ONLY_HC = -1939729611;
    private static final byte[] SAME_SITE = ByteBufStrings.encodeAscii((String)"SameSite");
    private static final int SAME_SITE_HC = 158165934;
    private static final int SAME_SITE_LAX_HC = 105954;
    private static final int SAME_SITE_STRICT_HC = -920615382;
    private static final int SAME_SITE_NONE_HC = 3357401;
    private final String name;
    private String value;
    private long expirationDate = -1L;
    private int maxAge = -1;
    private String domain;
    private String path = "";
    private boolean secure;
    private boolean httpOnly;
    @Nullable
    private SameSite sameSite;
    private String extension;

    private HttpCookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpCookie(String name, String value, String path) {
        this(name, value);
        this.path = path;
    }

    public static HttpCookie of(String name, String value, String path) {
        return new HttpCookie(name, value, path);
    }

    public static HttpCookie of(String name, String value) {
        return new HttpCookie(name, value);
    }

    public static HttpCookie of(String name) {
        return new HttpCookie(name, null);
    }

    public HttpCookie withValue(String value) {
        this.setValue(value);
        return this;
    }

    public HttpCookie withExpirationDate(Instant expirationDate) {
        this.setExpirationDate(expirationDate);
        return this;
    }

    public HttpCookie withMaxAge(int maxAge) {
        this.setMaxAge(maxAge);
        return this;
    }

    public HttpCookie withMaxAge(Duration maxAge) {
        this.setMaxAge(maxAge);
        return this;
    }

    public HttpCookie withDomain(String domain) {
        this.setDomain(domain);
        return this;
    }

    public HttpCookie withPath(String path) {
        this.setPath(path);
        return this;
    }

    public HttpCookie withSecure(boolean secure) {
        this.setSecure(secure);
        return this;
    }

    public HttpCookie withHttpOnly(boolean httpOnly) {
        this.setHttpOnly(httpOnly);
        return this;
    }

    public HttpCookie withSameSite(@NotNull SameSite sameSite) {
        this.setSameSite(sameSite);
        return this;
    }

    public HttpCookie withExtension(String extension) {
        this.setExtension(extension);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Instant getExpirationDate() {
        return Instant.ofEpochSecond(this.expirationDate);
    }

    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate.getEpochSecond();
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = (int)maxAge.getSeconds();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Nullable
    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(@NotNull SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    static void decodeFull(byte[] bytes, int pos, int end, List<HttpCookie> cookies) throws MalformedHttpException {
        try {
            HttpCookie cookie = new HttpCookie("", "", "/");
            while (pos < end) {
                int keyStart = pos = HttpUtils.skipSpaces(bytes, pos, end);
                while (pos < end && bytes[pos] != 59) {
                    ++pos;
                }
                int valueEnd = pos;
                int equalSign = -1;
                for (int i = keyStart; i < valueEnd; ++i) {
                    if (bytes[i] != 61) continue;
                    equalSign = i;
                    break;
                }
                AvHandler handler = HttpCookie.getCookieHandler(ByteBufStrings.hashCodeLowerCaseAscii((byte[])bytes, (int)keyStart, (int)((equalSign == -1 ? valueEnd : equalSign) - keyStart)));
                if (equalSign == -1 && handler == null) {
                    cookie.setExtension(ByteBufStrings.decodeAscii((byte[])bytes, (int)keyStart, (int)(valueEnd - keyStart)));
                } else if (handler == null) {
                    String key = ByteBufStrings.decodeAscii((byte[])bytes, (int)keyStart, (int)(equalSign - keyStart));
                    String value = bytes[equalSign + 1] == 34 && bytes[valueEnd - 1] == 34 ? ByteBufStrings.decodeAscii((byte[])bytes, (int)(equalSign + 2), (int)(valueEnd - equalSign - 3)) : ByteBufStrings.decodeAscii((byte[])bytes, (int)(equalSign + 1), (int)(valueEnd - equalSign - 1));
                    cookie = new HttpCookie(key, value, "/");
                    cookies.add(cookie);
                } else {
                    handler.handle(cookie, bytes, equalSign + 1, valueEnd);
                }
                pos = valueEnd + 1;
            }
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode cookies", e);
        }
    }

    static void renderSimple(List<HttpCookie> cookies, ByteBuf buf) {
        int pos = HttpCookie.renderSimple(cookies, buf.array(), buf.tail());
        buf.tail(pos);
    }

    static int renderSimple(List<HttpCookie> cookies, byte[] bytes, int pos) {
        for (int i = 0; i < cookies.size(); ++i) {
            HttpCookie cookie = cookies.get(i);
            pos += ByteBufStrings.encodeAscii((byte[])bytes, (int)pos, (String)cookie.name);
            if (cookie.value != null) {
                bytes[pos++] = 61;
                pos += ByteBufStrings.encodeAscii((byte[])bytes, (int)pos, (String)cookie.value);
            }
            if (i == cookies.size() - 1) continue;
            bytes[pos++] = 59;
            bytes[pos++] = 32;
        }
        return pos;
    }

    static void decodeSimple(byte[] bytes, int pos, int end, List<HttpCookie> cookies) throws MalformedHttpException {
        try {
            while (pos < end) {
                String key;
                int keyStart = pos = HttpUtils.skipSpaces(bytes, pos, end);
                while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                    ++pos;
                }
                int valueEnd = pos;
                int equalSign = -1;
                for (int i = keyStart; i < valueEnd; ++i) {
                    if (bytes[i] != 61) continue;
                    equalSign = i;
                    break;
                }
                if (equalSign == -1) {
                    key = ByteBufStrings.decodeAscii((byte[])bytes, (int)keyStart, (int)(valueEnd - keyStart));
                    cookies.add(new HttpCookie(key, null));
                } else {
                    key = ByteBufStrings.decodeAscii((byte[])bytes, (int)keyStart, (int)(equalSign - keyStart));
                    String value = bytes[equalSign + 1] == 34 && bytes[valueEnd - 1] == 34 ? ByteBufStrings.decodeAscii((byte[])bytes, (int)(equalSign + 2), (int)(valueEnd - equalSign - 3)) : ByteBufStrings.decodeAscii((byte[])bytes, (int)(equalSign + 1), (int)(valueEnd - equalSign - 1));
                    cookies.add(new HttpCookie(key, value));
                }
                pos = valueEnd + 1;
            }
        }
        catch (RuntimeException e) {
            throw new MalformedHttpException("Failed to decode cookies", e);
        }
    }

    void renderFull(ByteBuf buf) {
        int pos = this.renderFull(buf.array(), buf.tail());
        buf.tail(pos);
    }

    int renderFull(byte[] container, int pos) {
        pos += ByteBufStrings.encodeAscii((byte[])container, (int)pos, (String)this.name);
        container[pos++] = 61;
        if (this.value != null) {
            pos += ByteBufStrings.encodeAscii((byte[])container, (int)pos, (String)this.value);
        }
        if (this.expirationDate != -1L) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte expireByte : EXPIRES) {
                container[pos++] = expireByte;
            }
            container[pos++] = 61;
            pos = HttpDate.render(this.expirationDate, container, pos);
        }
        if (this.maxAge >= 0) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte maxAgeByte : MAX_AGE) {
                container[pos++] = maxAgeByte;
            }
            container[pos++] = 61;
            pos += ByteBufStrings.encodePositiveInt((byte[])container, (int)pos, (int)this.maxAge);
        }
        if (this.domain != null) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte domainByte : DOMAIN) {
                container[pos++] = domainByte;
            }
            container[pos++] = 61;
            pos += ByteBufStrings.encodeAscii((byte[])container, (int)pos, (String)this.domain);
        }
        if (this.path != null && !this.path.equals("")) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte pathByte : PATH) {
                container[pos++] = pathByte;
            }
            container[pos++] = 61;
            pos += ByteBufStrings.encodeAscii((byte[])container, (int)pos, (String)this.path);
        }
        if (this.secure) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte secureByte : SECURE) {
                container[pos++] = secureByte;
            }
        }
        if (this.httpOnly) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte httpOnlyByte : HTTPONLY) {
                container[pos++] = httpOnlyByte;
            }
        }
        if (this.sameSite != null) {
            container[pos++] = 59;
            container[pos++] = 32;
            for (byte sameSiteByte : SAME_SITE) {
                container[pos++] = sameSiteByte;
            }
            container[pos++] = 61;
            for (byte sameSiteValueByte : this.sameSite.bytes) {
                container[pos++] = sameSiteValueByte;
            }
        }
        if (this.extension != null) {
            container[pos++] = 59;
            container[pos++] = 32;
            pos += ByteBufStrings.encodeAscii((byte[])container, (int)pos, (String)this.extension);
        }
        return pos;
    }

    private static AvHandler getCookieHandler(int hash) {
        switch (hash) {
            case 433574931: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) throws MalformedHttpException {
                        cookie.setExpirationDate(HttpCookie.decodeExpirationDate(bytes, start));
                    }
                };
            }
            case -1709216267: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) throws MalformedHttpException {
                        cookie.setMaxAge(HttpCookie.decodeMaxAge(bytes, start, end));
                    }
                };
            }
            case -438693883: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) {
                        cookie.setDomain(ByteBufStrings.decodeAscii((byte[])bytes, (int)start, (int)(end - start)));
                    }
                };
            }
            case 4357030: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) {
                        cookie.setPath(ByteBufStrings.decodeAscii((byte[])bytes, (int)start, (int)(end - start)));
                    }
                };
            }
            case -18770248: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) {
                        cookie.setSecure(true);
                    }
                };
            }
            case -1939729611: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) {
                        cookie.setHttpOnly(true);
                    }
                };
            }
            case 158165934: {
                return new AvHandler(){

                    @Override
                    protected void handle(HttpCookie cookie, byte[] bytes, int start, int end) throws MalformedHttpException {
                        int sameSiteHc = ByteBufStrings.hashCode((byte[])bytes, (int)start, (int)(end - start));
                        switch (sameSiteHc) {
                            case 105954: {
                                cookie.setSameSite(SameSite.LAX);
                                break;
                            }
                            case -920615382: {
                                cookie.setSameSite(SameSite.STRICT);
                                break;
                            }
                            case 3357401: {
                                cookie.setSameSite(SameSite.NONE);
                                break;
                            }
                            default: {
                                throw new MalformedHttpException("Unknown SameSite value: " + new String(bytes, start, end - start, StandardCharsets.ISO_8859_1));
                            }
                        }
                    }
                };
            }
        }
        return null;
    }

    private static Instant decodeExpirationDate(byte[] bytes, int start) throws MalformedHttpException {
        return Instant.ofEpochSecond(HttpDate.decode(bytes, start));
    }

    private static Duration decodeMaxAge(byte[] bytes, int start, int end) throws MalformedHttpException {
        return Duration.ofSeconds(HttpUtils.trimAndDecodePositiveInt(bytes, start, end - start));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCookie that = (HttpCookie)o;
        return this.maxAge == that.maxAge && this.secure == that.secure && this.httpOnly == that.httpOnly && this.expirationDate == that.expirationDate && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.domain, that.domain) && Objects.equals(this.path, that.path) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.expirationDate, this.maxAge, this.domain, this.path, this.secure, this.httpOnly, this.extension);
    }

    public String toString() {
        return "HttpCookie{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static enum SameSite {
        LAX(ByteBufStrings.encodeAscii((String)"Lax")),
        STRICT(ByteBufStrings.encodeAscii((String)"Strict")),
        NONE(ByteBufStrings.encodeAscii((String)"None"));

        private final byte[] bytes;

        private SameSite(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    private static abstract class AvHandler {
        private AvHandler() {
        }

        protected abstract void handle(HttpCookie var1, byte[] var2, int var3, int var4) throws MalformedHttpException;
    }
}

