/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;

final class HttpDate {
    private static final int HOUR_SECONDS = 3600;
    private static final int DAY_SECONDS = 86400;
    private static final int YEAR_SECONDS = 31536000;
    private static final int FOUR_YEAR_SECONDS = 126230400;
    private static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_IN_MONTH_LEAP = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] GMT = ByteBufStrings.encodeAscii((String)"GMT");
    private static final byte[][] DAYS_OF_WEEK = new byte[7][];
    private static final byte[][] MONTHS_IN_YEAR;

    HttpDate() {
    }

    static long decode(byte[] bytes, int start) throws MalformedHttpException {
        try {
            int i;
            int day = HttpUtils.trimAndDecodePositiveInt(bytes, start + 5, 2);
            int month = -1;
            for (int i2 = 0; i2 < MONTHS_IN_YEAR.length; ++i2) {
                byte[] entry = MONTHS_IN_YEAR[i2];
                if (entry[0] != bytes[start + 8] || entry[1] != bytes[start + 9] || entry[2] != bytes[start + 10]) continue;
                month = i2;
            }
            int yearLength = 48 <= bytes[start + 12 + 2] && bytes[start + 12 + 2] <= 57 ? 4 : 2;
            int year = (yearLength == 2 ? 2000 : 0) + HttpUtils.trimAndDecodePositiveInt(bytes, start + 12, yearLength);
            int hour = HttpUtils.trimAndDecodePositiveInt(bytes, start + 13 + yearLength, 2);
            int minutes = HttpUtils.trimAndDecodePositiveInt(bytes, start + 16 + yearLength, 2);
            int seconds = HttpUtils.trimAndDecodePositiveInt(bytes, start + 19 + yearLength, 2);
            boolean isLeapYear = HttpDate.isLeap(year);
            int[] days = isLeapYear ? DAYS_IN_MONTH_LEAP : DAYS_IN_MONTH;
            int yearsLeft = (year -= 1970) % 4;
            long timestamp = 0L;
            int fy = (year - yearsLeft) / 4;
            for (i = 0; i < fy; ++i) {
                timestamp += 126230400L;
            }
            timestamp += (long)(yearsLeft * 31536000);
            if (yearsLeft > 2) {
                timestamp += 86400L;
            }
            for (i = 0; i < month; ++i) {
                timestamp += 86400L * (long)days[i];
            }
            for (i = 1; i < day; ++i) {
                timestamp += 86400L;
            }
            return timestamp += (60L * (long)hour + (long)minutes) * 60L + (long)seconds;
        }
        catch (RuntimeException ignored) {
            throw new MalformedHttpException("Failed to decode date");
        }
    }

    static void render(long epochSeconds, ByteBuf buf) {
        int pos = HttpDate.render(epochSeconds, buf.array(), buf.tail());
        buf.tail(pos);
    }

    static int render(long epochSeconds, byte[] bytes, int pos) {
        byte[] stringMonth;
        byte[] stringDay;
        int day;
        int fourYears = (int)(epochSeconds / 126230400L);
        int year = fourYears * 4 + 1970;
        int seconds = (int)(epochSeconds - (long)(fourYears * 126230400));
        boolean isLeapYear = false;
        if (seconds >= 31536000) {
            ++year;
            if ((seconds -= 31536000) >= 31536000) {
                ++year;
                if ((seconds -= 31536000) >= 31622400) {
                    ++year;
                    seconds -= 31622400;
                } else {
                    isLeapYear = true;
                }
            }
        }
        int dayOfYear = seconds / 86400;
        seconds -= dayOfYear * 86400;
        int[] monthsDays = isLeapYear ? DAYS_IN_MONTH_LEAP : DAYS_IN_MONTH;
        int month = 0;
        for (day = dayOfYear; day >= monthsDays[month]; day -= monthsDays[month++]) {
        }
        int hours = seconds / 3600;
        int minutes = (seconds -= hours * 3600) / 60;
        seconds -= minutes * 60;
        int dayOfWeek = (int)((epochSeconds / 86400L + 4L) % 7L) + 1;
        for (byte b : stringDay = DAYS_OF_WEEK[dayOfWeek - 1]) {
            bytes[pos++] = b;
        }
        bytes[pos++] = 44;
        bytes[pos++] = 32;
        if (day < 9) {
            bytes[pos++] = 48;
        }
        pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)(++day));
        bytes[pos++] = 32;
        for (byte b : stringMonth = MONTHS_IN_YEAR[month]) {
            bytes[pos++] = b;
        }
        bytes[pos++] = 32;
        pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)year);
        bytes[pos++] = 32;
        if (hours < 10) {
            bytes[pos++] = 48;
        }
        pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)hours);
        bytes[pos++] = 58;
        if (minutes < 10) {
            bytes[pos++] = 48;
        }
        pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)minutes);
        bytes[pos++] = 58;
        if (seconds < 10) {
            bytes[pos++] = 48;
        }
        pos += ByteBufStrings.encodePositiveInt((byte[])bytes, (int)pos, (int)seconds);
        bytes[pos++] = 32;
        for (byte b : GMT) {
            bytes[pos++] = b;
        }
        return pos;
    }

    private static boolean isLeap(int year) {
        if (year % 4 == 0) {
            if (year % 100 == 0) {
                return year % 400 == 0;
            }
            return true;
        }
        return false;
    }

    static {
        HttpDate.DAYS_OF_WEEK[0] = ByteBufStrings.encodeAscii((String)"Sun");
        HttpDate.DAYS_OF_WEEK[1] = ByteBufStrings.encodeAscii((String)"Mon");
        HttpDate.DAYS_OF_WEEK[2] = ByteBufStrings.encodeAscii((String)"Tue");
        HttpDate.DAYS_OF_WEEK[3] = ByteBufStrings.encodeAscii((String)"Wed");
        HttpDate.DAYS_OF_WEEK[4] = ByteBufStrings.encodeAscii((String)"Thu");
        HttpDate.DAYS_OF_WEEK[5] = ByteBufStrings.encodeAscii((String)"Fri");
        HttpDate.DAYS_OF_WEEK[6] = ByteBufStrings.encodeAscii((String)"Sat");
        MONTHS_IN_YEAR = new byte[12][];
        HttpDate.MONTHS_IN_YEAR[0] = ByteBufStrings.encodeAscii((String)"Jan");
        HttpDate.MONTHS_IN_YEAR[1] = ByteBufStrings.encodeAscii((String)"Feb");
        HttpDate.MONTHS_IN_YEAR[2] = ByteBufStrings.encodeAscii((String)"Mar");
        HttpDate.MONTHS_IN_YEAR[3] = ByteBufStrings.encodeAscii((String)"Apr");
        HttpDate.MONTHS_IN_YEAR[4] = ByteBufStrings.encodeAscii((String)"May");
        HttpDate.MONTHS_IN_YEAR[5] = ByteBufStrings.encodeAscii((String)"Jun");
        HttpDate.MONTHS_IN_YEAR[6] = ByteBufStrings.encodeAscii((String)"Jul");
        HttpDate.MONTHS_IN_YEAR[7] = ByteBufStrings.encodeAscii((String)"Aug");
        HttpDate.MONTHS_IN_YEAR[8] = ByteBufStrings.encodeAscii((String)"Sep");
        HttpDate.MONTHS_IN_YEAR[9] = ByteBufStrings.encodeAscii((String)"Oct");
        HttpDate.MONTHS_IN_YEAR[10] = ByteBufStrings.encodeAscii((String)"Nov");
        HttpDate.MONTHS_IN_YEAR[11] = ByteBufStrings.encodeAscii((String)"Dec");
    }
}

