/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.ApplicationSettings;
import io.activej.http.HttpException;
import io.activej.http.HttpResponse;
import io.activej.promise.Promisable;
import io.activej.promise.Promise;

public class HttpError
extends HttpException
implements Promisable<HttpResponse> {
    public static final boolean WITH_STACK_TRACE = ApplicationSettings.getBoolean(HttpError.class, (String)"withStackTrace", (boolean)false);
    private final int code;

    protected HttpError(int code) {
        this.code = code;
    }

    protected HttpError(int code, String message) {
        super(message);
        this.code = code;
    }

    protected HttpError(int code, String message, Exception cause) {
        super(message, cause);
        this.code = code;
    }

    protected HttpError(int code, Exception cause) {
        super(cause);
        this.code = code;
    }

    public static HttpError ofCode(int code) {
        return new HttpError(code);
    }

    public static HttpError ofCode(int code, String message) {
        return new HttpError(code, message);
    }

    public static HttpError ofCode(int code, String message, Exception cause) {
        return new HttpError(code, message, cause);
    }

    public static HttpError ofCode(int code, Exception cause) {
        return new HttpError(code, cause);
    }

    public static HttpError badRequest400(String message) {
        return new HttpError(400, message);
    }

    public static HttpError notFound404() {
        return new HttpError(404, "Not found");
    }

    public static HttpError internalServerError500() {
        return new HttpError(500, "Internal server error");
    }

    public static HttpError notAllowed405() {
        return new HttpError(405, "Not allowed");
    }

    public final int getCode() {
        return this.code;
    }

    public Promise<HttpResponse> promise() {
        return Promise.ofException((Exception)this);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return WITH_STACK_TRACE ? super.fillInStackTrace() : this;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return "HTTP code " + this.code + ": " + msg;
        }
        return "HTTP code " + this.code;
    }
}

