/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.http.DebugStacktraceRenderer;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface HttpExceptionFormatter {
    public static final String ACTIVEJ_VERSION = "5.2";
    @Language(value="HTML")
    public static final String HTTP_ERROR_HTML = "<!doctype html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>{title}</title><style>h1, p { font-family: sans-serif; }</style></head><body><h1 style=\"text-align: center;\">{title}</h1><hr><p style=\"text-align: center\">{message}</p><hr><p style=\"text-align: center;\">ActiveJ 5.2</p></body></html>";
    public static final String INTERNAL_SERVER_ERROR_HTML = "<!doctype html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>{title}</title><style>h1, p { font-family: sans-serif; }</style></head><body><h1 style=\"text-align: center;\">{title}</h1><hr><p style=\"text-align: center\">{message}</p><hr><p style=\"text-align: center;\">ActiveJ 5.2</p></body></html>".replace("{title}", "Internal Server Error").replace("<p style=\"text-align: center\">{message}</p><hr>", "");
    public static final HttpExceptionFormatter DEFAULT_FORMATTER = e -> {
        HttpResponse response;
        if (e instanceof HttpError) {
            int code = ((HttpError)e).getCode();
            response = HttpResponse.ofCode(code).withHtml(HTTP_ERROR_HTML.replace("{title}", HttpUtils.getHttpErrorTitle(code)).replace("{message}", e.toString()));
        } else {
            response = HttpResponse.ofCode(500).withHtml(INTERNAL_SERVER_ERROR_HTML);
        }
        return response.withHeader(HttpHeaders.CACHE_CONTROL, "no-store").withHeader(HttpHeaders.PRAGMA, "no-cache").withHeader(HttpHeaders.AGE, "0");
    };
    public static final HttpExceptionFormatter DEBUG_FORMATTER = e -> DebugStacktraceRenderer.render(e, e instanceof HttpError ? ((HttpError)e).getCode() : 500).withHeader(HttpHeaders.CACHE_CONTROL, "no-store").withHeader(HttpHeaders.PRAGMA, "no-cache").withHeader(HttpHeaders.AGE, "0");
    public static final HttpExceptionFormatter COMMON_FORMATTER = System.getProperty("java.class.path", "").contains("idea_rt.jar") ? DEBUG_FORMATTER : DEFAULT_FORMATTER;

    @NotNull
    public HttpResponse formatException(@NotNull Exception var1);
}

