/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.http.AcceptCharset;
import io.activej.http.AcceptMediaType;
import io.activej.http.ContentType;
import io.activej.http.HttpCookie;
import io.activej.http.HttpDate;
import io.activej.http.HttpUtils;
import io.activej.http.MalformedHttpException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class HttpHeaderValue {
    abstract int estimateSize();

    abstract int writeTo(byte[] var1, int var2);

    @NotNull
    public abstract String toString();

    @NotNull
    public static HttpHeaderValue of(@NotNull String string) {
        return new HttpHeaderValueOfString(string);
    }

    @NotNull
    public static HttpHeaderValue ofBytes(byte[] array, int offset, int size) {
        return new HttpHeaderValueOfBytes(array, offset, size);
    }

    @NotNull
    public static HttpHeaderValue ofBytes(byte[] array) {
        return HttpHeaderValue.ofBytes(array, 0, array.length);
    }

    @NotNull
    public static HttpHeaderValue ofDecimal(int value) {
        return new HttpHeaderValueOfUnsignedDecimal(value);
    }

    @NotNull
    public static HttpHeaderValue ofAcceptCharsets(@NotNull List<AcceptCharset> charsets) {
        return new HttpHeaderValueOfCharsets(charsets);
    }

    @NotNull
    public static HttpHeaderValue ofAcceptCharsets(AcceptCharset ... charsets) {
        return HttpHeaderValue.ofAcceptCharsets(Arrays.asList(charsets));
    }

    @NotNull
    public static HttpHeaderValue ofInstant(@NotNull Instant date) {
        return new HttpHeaderValueOfDate(date.getEpochSecond());
    }

    @NotNull
    public static HttpHeaderValue ofTimestamp(long timestamp) {
        return new HttpHeaderValueOfDate(timestamp / 1000L);
    }

    @NotNull
    public static HttpHeaderValue ofAcceptMediaTypes(@NotNull List<AcceptMediaType> type) {
        return new HttpHeaderValueOfAcceptMediaTypes(type);
    }

    @NotNull
    public static HttpHeaderValue ofAcceptMediaTypes(AcceptMediaType ... types) {
        return HttpHeaderValue.ofAcceptMediaTypes(Arrays.asList(types));
    }

    @NotNull
    public static HttpHeaderValue ofContentType(@NotNull ContentType type) {
        return new HttpHeaderValueOfContentType(type);
    }

    public static int toPositiveInt(@NotNull ByteBuf buf) throws MalformedHttpException {
        return HttpUtils.trimAndDecodePositiveInt(buf.array(), buf.head(), buf.readRemaining());
    }

    @NotNull
    public static ContentType toContentType(@NotNull ByteBuf buf) throws MalformedHttpException {
        return ContentType.decode(buf.array(), buf.head(), buf.readRemaining());
    }

    @NotNull
    public static Instant toInstant(@NotNull ByteBuf buf) throws MalformedHttpException {
        return Instant.ofEpochSecond(HttpDate.decode(buf.array(), buf.head()));
    }

    @NotNull
    public ByteBuf getBuf() {
        int estimatedSize = this.estimateSize();
        ByteBuf buf = ByteBuf.wrapForWriting((byte[])new byte[estimatedSize]);
        int pos = this.writeTo(buf.array(), 0);
        buf.tail(pos);
        return buf;
    }

    public static void toAcceptContentTypes(@NotNull ByteBuf buf, @NotNull List<AcceptMediaType> into) throws MalformedHttpException {
        AcceptMediaType.decode(buf.array(), buf.head(), buf.readRemaining(), into);
    }

    public static void toAcceptCharsets(@NotNull ByteBuf buf, @NotNull List<AcceptCharset> into) throws MalformedHttpException {
        AcceptCharset.decode(buf.array(), buf.head(), buf.readRemaining(), into);
    }

    static void toSimpleCookies(@NotNull ByteBuf buf, @NotNull List<HttpCookie> into) throws MalformedHttpException {
        HttpCookie.decodeSimple(buf.array(), buf.head(), buf.tail(), into);
    }

    static void toFullCookies(@NotNull ByteBuf buf, @NotNull List<HttpCookie> into) throws MalformedHttpException {
        HttpCookie.decodeFull(buf.array(), buf.head(), buf.tail(), into);
    }

    static final class HttpHeaderValueOfString
    extends HttpHeaderValue {
        @NotNull
        private final String string;

        HttpHeaderValueOfString(@NotNull String string) {
            this.string = string;
        }

        @Override
        int estimateSize() {
            return this.string.length();
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return offset + ByteBufStrings.encodeAscii((byte[])array, (int)offset, (String)this.string);
        }

        @Override
        @NotNull
        public String toString() {
            return this.string;
        }
    }

    static final class HttpHeaderValueOfBytes
    extends HttpHeaderValue {
        private final byte[] array;
        private final int offset;
        private final int size;

        HttpHeaderValueOfBytes(byte[] array, int offset, int size) {
            this.array = array;
            this.offset = offset;
            this.size = size;
        }

        @Override
        int estimateSize() {
            return this.size;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            if (this.array.length < 10) {
                for (byte b : this.array) {
                    array[offset++] = b;
                }
                return offset;
            }
            System.arraycopy(this.array, this.offset, array, offset, this.size);
            return offset + this.size;
        }

        @Override
        @NotNull
        public ByteBuf getBuf() {
            return ByteBuf.wrap((byte[])this.array, (int)this.offset, (int)(this.offset + this.size));
        }

        @Override
        @NotNull
        public String toString() {
            return ByteBufStrings.decodeAscii((byte[])this.array, (int)this.offset, (int)this.size);
        }
    }

    static final class HttpHeaderValueOfUnsignedDecimal
    extends HttpHeaderValue {
        private final int value;

        HttpHeaderValueOfUnsignedDecimal(int value) {
            this.value = value;
        }

        @Override
        int estimateSize() {
            return 10;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return offset + ByteBufStrings.encodePositiveInt((byte[])array, (int)offset, (int)this.value);
        }

        @Override
        @NotNull
        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static final class HttpHeaderValueOfCharsets
    extends HttpHeaderValue {
        @NotNull
        private final List<AcceptCharset> charsets;

        HttpHeaderValueOfCharsets(@NotNull List<AcceptCharset> charsets) {
            this.charsets = charsets;
        }

        @Override
        int estimateSize() {
            int size = 0;
            for (AcceptCharset charset : this.charsets) {
                size += charset.estimateSize() + 2;
            }
            return size;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return AcceptCharset.render(this.charsets, array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            AcceptCharset.render(this.charsets, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    static final class HttpHeaderValueOfDate
    extends HttpHeaderValue {
        private final long epochSeconds;

        HttpHeaderValueOfDate(long epochSeconds) {
            this.epochSeconds = epochSeconds;
        }

        @Override
        int estimateSize() {
            return 29;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return HttpDate.render(this.epochSeconds, array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            HttpDate.render(this.epochSeconds, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    static final class HttpHeaderValueOfAcceptMediaTypes
    extends HttpHeaderValue {
        @NotNull
        private final List<AcceptMediaType> types;

        HttpHeaderValueOfAcceptMediaTypes(@NotNull List<AcceptMediaType> types) {
            this.types = types;
        }

        @Override
        public int estimateSize() {
            int size = 0;
            for (AcceptMediaType type : this.types) {
                size += type.estimateSize() + 2;
            }
            return size;
        }

        @Override
        public int writeTo(byte[] array, int offset) {
            return AcceptMediaType.render(this.types, array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            AcceptMediaType.render(this.types, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    static final class HttpHeaderValueOfContentType
    extends HttpHeaderValue {
        @NotNull
        private final ContentType type;

        HttpHeaderValueOfContentType(@NotNull ContentType type) {
            this.type = type;
        }

        @Override
        public int estimateSize() {
            return this.type.size();
        }

        @Override
        public int writeTo(byte[] array, int offset) {
            return ContentType.render(this.type, array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            ContentType.render(this.type, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    static final class HttpHeaderValueOfSetCookies
    extends HttpHeaderValue {
        @NotNull
        final HttpCookie cookie;

        HttpHeaderValueOfSetCookies(@NotNull HttpCookie cookie) {
            this.cookie = cookie;
        }

        @Override
        int estimateSize() {
            int size = 0;
            size += this.cookie.getName().length();
            size += this.cookie.getValue() == null ? 0 : this.cookie.getValue().length() + 1;
            size += this.cookie.getDomain() == null ? 0 : this.cookie.getDomain().length() + 10;
            size += this.cookie.getPath() == null ? 0 : this.cookie.getPath().length() + 6;
            size += this.cookie.getExtension() == null ? 0 : this.cookie.getExtension().length();
            return size += 102;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return this.cookie.renderFull(array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            this.cookie.renderFull(buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    static final class HttpHeaderValueOfSimpleCookies
    extends HttpHeaderValue {
        @NotNull
        final List<HttpCookie> cookies;

        HttpHeaderValueOfSimpleCookies(@NotNull List<HttpCookie> cookies) {
            this.cookies = cookies;
        }

        @Override
        int estimateSize() {
            int size = 0;
            for (HttpCookie cookie : this.cookies) {
                size += cookie.getName().length();
                size += cookie.getValue() == null ? 0 : cookie.getValue().length() + 1;
            }
            return size += (this.cookies.size() - 1) * 2;
        }

        @Override
        int writeTo(byte[] array, int offset) {
            return HttpCookie.renderSimple(this.cookies, array, offset);
        }

        @Override
        @NotNull
        public String toString() {
            ByteBuf buf = ByteBufPool.allocate((int)this.estimateSize());
            HttpCookie.renderSimple(this.cookies, buf);
            return ByteBufStrings.asAscii((ByteBuf)buf);
        }
    }

    @FunctionalInterface
    public static interface DecoderIntoList<T> {
        public void decode(@NotNull ByteBuf var1, @NotNull List<T> var2) throws MalformedHttpException;
    }
}

