/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.csp.ChannelSupplier;
import io.activej.http.ContentType;
import io.activej.http.ContentTypes;
import io.activej.http.HttpClientConnection;
import io.activej.http.HttpCookie;
import io.activej.http.HttpError;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpVersion;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import io.activej.promise.Promisable;
import io.activej.promise.Promise;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpResponse
extends HttpMessage
implements Promisable<HttpResponse>,
WithInitializer<HttpResponse> {
    private static final boolean CHECK = Checks.isEnabled(HttpResponse.class);
    private static final byte[] HTTP11_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 ");
    private static final byte[] CODE_ERROR_BYTES = ByteBufStrings.encodeAscii((String)" Error");
    private static final byte[] CODE_OK_BYTES = ByteBufStrings.encodeAscii((String)" OK");
    private static final byte[] CODE_100_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 100 Continue");
    private static final byte[] CODE_101_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 101 Switching protocols");
    private static final byte[] CODE_102_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 102 Processing");
    private static final byte[] CODE_103_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 103 Early Hints");
    private static final byte[] CODE_200_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 200 OK");
    private static final byte[] CODE_201_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 201 Created");
    private static final byte[] CODE_202_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 202 Accepted");
    private static final byte[] CODE_203_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 203 Non-Authoritative Information");
    private static final byte[] CODE_204_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 204 No Content");
    private static final byte[] CODE_205_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 205 Reset Content");
    private static final byte[] CODE_206_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 206 Partial Content");
    private static final byte[] CODE_207_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 207 Multi-Status");
    private static final byte[] CODE_208_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 208 Already Reported");
    private static final byte[] CODE_226_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 226 IM Used");
    private static final byte[] CODE_300_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 300 Multiple Choices");
    private static final byte[] CODE_301_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 301 Moved Permanently");
    private static final byte[] CODE_302_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 302 Found");
    private static final byte[] CODE_303_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 303 See Other");
    private static final byte[] CODE_304_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 304 Not Modified");
    private static final byte[] CODE_305_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 305 Use Proxy");
    private static final byte[] CODE_307_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 307 Temporary Redirect");
    private static final byte[] CODE_308_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 308 Permanent Redirect");
    private static final byte[] CODE_400_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 400 Bad Request");
    private static final byte[] CODE_401_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 401 Unauthorized");
    private static final byte[] CODE_402_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 402 Payment required");
    private static final byte[] CODE_403_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 403 Forbidden");
    private static final byte[] CODE_404_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 404 Not Found");
    private static final byte[] CODE_405_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 405 Method Not Allowed");
    private static final byte[] CODE_406_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 406 Not Acceptable");
    private static final byte[] CODE_407_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 407 Proxy Authentication Required");
    private static final byte[] CODE_408_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 408 Request Timeout");
    private static final byte[] CODE_409_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 409 Conflict");
    private static final byte[] CODE_410_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 410 Gone");
    private static final byte[] CODE_411_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 411 Length Required");
    private static final byte[] CODE_412_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 412 Precondition Failed");
    private static final byte[] CODE_413_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 413 Payload Too Large");
    private static final byte[] CODE_414_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 414 URI Too Long");
    private static final byte[] CODE_415_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 415 Unsupported Media Type");
    private static final byte[] CODE_416_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 416 Range Not Satisfiable");
    private static final byte[] CODE_417_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 417 Expectation Failed");
    private static final byte[] CODE_421_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 421 Misdirected Request");
    private static final byte[] CODE_422_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 422 Unprocessable Entity");
    private static final byte[] CODE_423_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 423 Locked");
    private static final byte[] CODE_424_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 424 Failed Dependency");
    private static final byte[] CODE_425_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 425 Too Early");
    private static final byte[] CODE_426_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 426 Upgrade Required");
    private static final byte[] CODE_428_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 428 Precondition Required");
    private static final byte[] CODE_429_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 429 Too Many Requests");
    private static final byte[] CODE_431_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 431 Request Header Fields Too Large");
    private static final byte[] CODE_451_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 451 Unavailable For Legal Reasons");
    private static final byte[] CODE_500_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 500 Internal Server Error");
    private static final byte[] CODE_501_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 501 Not Implemented");
    private static final byte[] CODE_502_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 502 Bad Gateway");
    private static final byte[] CODE_503_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 503 Service Unavailable");
    private static final byte[] CODE_504_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 504 Gateway Timeout");
    private static final byte[] CODE_505_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 505 HTTP Version Not Supported");
    private static final byte[] CODE_506_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 506 Variant Also Negotiates");
    private static final byte[] CODE_507_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 507 Insufficient Storage");
    private static final byte[] CODE_508_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 508 Loop Detected");
    private static final byte[] CODE_510_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 510 Not Extended");
    private static final byte[] CODE_511_BYTES = ByteBufStrings.encodeAscii((String)"HTTP/1.1 511 Network Authentication Required");
    private static final int LONGEST_FIRST_LINE_SIZE = CODE_511_BYTES.length;
    private final int code;
    private final HttpClientConnection connection;
    @Nullable
    private Map<String, HttpCookie> parsedCookies;

    HttpResponse(HttpVersion version, int code, @Nullable HttpClientConnection connection) {
        super(version);
        this.code = code;
        this.connection = connection;
    }

    HttpResponse(HttpVersion version, int code) {
        this(version, code, null);
    }

    @NotNull
    public static HttpResponse ofCode(int code) {
        if (CHECK) {
            Checks.checkArgument((code >= 100 && code < 600 ? 1 : 0) != 0, (Object)"Code should be in range [100, 600)");
        }
        return new HttpResponse(HttpVersion.HTTP_1_1, code);
    }

    @NotNull
    public static HttpResponse ok200() {
        return new HttpResponse(HttpVersion.HTTP_1_1, 200);
    }

    @NotNull
    public static HttpResponse ok201() {
        return new HttpResponse(HttpVersion.HTTP_1_1, 201);
    }

    @NotNull
    public static HttpResponse ok206() {
        return new HttpResponse(HttpVersion.HTTP_1_1, 206);
    }

    @NotNull
    public static HttpResponse redirect301(@NotNull String url) {
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, 301);
        response.addHeader(HttpHeaders.LOCATION, url);
        return response;
    }

    @NotNull
    public static HttpResponse redirect302(@NotNull String url) {
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, 302);
        response.addHeader(HttpHeaders.LOCATION, url);
        return response;
    }

    @NotNull
    public static HttpResponse redirect307(@NotNull String url) {
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, 307);
        response.addHeader(HttpHeaders.LOCATION, url);
        return response;
    }

    @NotNull
    public static HttpResponse redirect308(@NotNull String url) {
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, 308);
        response.addHeader(HttpHeaders.LOCATION, url);
        return response;
    }

    @NotNull
    public static HttpResponse unauthorized401(@NotNull String challenge) {
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, 401);
        response.addHeader(HttpHeaders.WWW_AUTHENTICATE, challenge);
        return response;
    }

    @NotNull
    public static HttpResponse notFound404() {
        return new HttpResponse(HttpVersion.HTTP_1_1, 404);
    }

    @NotNull
    public static Promise<HttpResponse> file(FileSliceSupplier downloader, String name, long size, @Nullable String rangeHeader) {
        return HttpResponse.file(downloader, name, size, rangeHeader, false);
    }

    @NotNull
    public static Promise<HttpResponse> file(FileSliceSupplier downloader, String name, long size, @Nullable String rangeHeader, boolean inline) {
        long contentLength;
        long offset;
        HttpResponse response = new HttpResponse(HttpVersion.HTTP_1_1, rangeHeader == null ? 200 : 206);
        String localName = name.substring(name.lastIndexOf(47) + 1);
        MediaType mediaType = MediaTypes.getByExtension(localName.substring(localName.lastIndexOf(46) + 1));
        if (mediaType == null) {
            mediaType = MediaTypes.OCTET_STREAM;
        }
        response.addHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentType.of(mediaType)));
        response.addHeader(HttpHeaders.ACCEPT_RANGES, "bytes");
        response.addHeader(HttpHeaders.CONTENT_DISPOSITION, inline ? "inline" : "attachment; filename=\"" + localName + "\"");
        if (rangeHeader != null) {
            long endOffset;
            if (!rangeHeader.startsWith("bytes=")) {
                return Promise.ofException((Exception)HttpError.ofCode(416, "Invalid range header (not in bytes)"));
            }
            if (!(rangeHeader = rangeHeader.substring(6)).matches("(?:\\d+)?-(?:\\d+)?")) {
                return Promise.ofException((Exception)HttpError.ofCode(416, "Only single part ranges are allowed"));
            }
            String[] parts = rangeHeader.split("-", 2);
            if (parts[0].isEmpty()) {
                if (parts[1].isEmpty()) {
                    return Promise.ofException((Exception)HttpError.ofCode(416, "Invalid range"));
                }
                offset = size - Long.parseLong(parts[1]);
                endOffset = size;
            } else if (parts[1].isEmpty()) {
                offset = Long.parseLong(parts[0]);
                endOffset = size - 1L;
            } else {
                offset = Long.parseLong(parts[0]);
                endOffset = Long.parseLong(parts[1]);
            }
            if (endOffset != -1L && offset > endOffset) {
                return Promise.ofException((Exception)HttpError.ofCode(416, "Invalid range"));
            }
            contentLength = endOffset - offset + 1L;
            response.addHeader(HttpHeaders.CONTENT_RANGE, "bytes " + offset + "-" + endOffset + "/" + size);
        } else {
            contentLength = size;
            offset = 0L;
        }
        response.addHeader(HttpHeaders.CONTENT_LENGTH, Long.toString(contentLength));
        response.setBodyStream((ChannelSupplier<ByteBuf>)ChannelSupplier.ofPromise(downloader.getFileSlice(offset, contentLength)));
        return Promise.of((Object)response);
    }

    @NotNull
    public static Promise<HttpResponse> file(FileSliceSupplier downloader, String name, long size) {
        return HttpResponse.file(downloader, name, size, null);
    }

    @NotNull
    public HttpResponse withHeader(@NotNull HttpHeader header, @NotNull String value) {
        this.addHeader(header, value);
        return this;
    }

    @NotNull
    public HttpResponse withHeader(@NotNull HttpHeader header, byte[] bytes) {
        this.addHeader(header, bytes);
        return this;
    }

    @NotNull
    public HttpResponse withHeader(@NotNull HttpHeader header, @NotNull HttpHeaderValue value) {
        this.addHeader(header, value);
        return this;
    }

    @NotNull
    public HttpResponse withCookies(@NotNull List<HttpCookie> cookies) {
        this.addCookies(cookies);
        return this;
    }

    @NotNull
    public HttpResponse withCookies(HttpCookie ... cookies) {
        this.addCookies(cookies);
        return this;
    }

    @NotNull
    public HttpResponse withCookie(@NotNull HttpCookie cookie) {
        this.addCookie(cookie);
        return this;
    }

    @NotNull
    public HttpResponse withBodyGzipCompression() {
        this.setBodyGzipCompression();
        return this;
    }

    @NotNull
    public HttpResponse withBody(@NotNull ByteBuf body) {
        this.setBody(body);
        return this;
    }

    @NotNull
    public HttpResponse withBody(byte[] array) {
        this.setBody(array);
        return this;
    }

    @NotNull
    public HttpResponse withBodyStream(@NotNull ChannelSupplier<ByteBuf> stream) {
        this.setBodyStream(stream);
        return this;
    }

    @NotNull
    public HttpResponse withPlainText(@NotNull String text) {
        return this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.PLAIN_TEXT_UTF_8)).withBody(text.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public HttpResponse withHtml(@NotNull String text) {
        return this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.HTML_UTF_8)).withBody(text.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public HttpResponse withJson(@NotNull String text) {
        return this.withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(ContentTypes.JSON_UTF_8)).withBody(text.getBytes(StandardCharsets.UTF_8));
    }

    public Promise<HttpResponse> promise() {
        return Promise.of((Object)this);
    }

    @Override
    public void addCookies(@NotNull List<HttpCookie> cookies) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        for (HttpCookie cookie : cookies) {
            this.addCookie(cookie);
        }
    }

    @Override
    public void addCookie(@NotNull HttpCookie cookie) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        this.addHeader(HttpHeaders.SET_COOKIE, new HttpHeaderValue.HttpHeaderValueOfSetCookies(cookie));
    }

    @Override
    boolean isContentLengthExpected() {
        return true;
    }

    public HttpClientConnection getConnection() {
        return this.connection;
    }

    public int getCode() {
        return this.code;
    }

    @NotNull
    public Map<String, HttpCookie> getCookies() {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        if (this.parsedCookies != null) {
            return this.parsedCookies;
        }
        LinkedHashMap<String, HttpCookie> cookies = new LinkedHashMap<String, HttpCookie>();
        for (HttpCookie cookie : this.getHeader(HttpHeaders.SET_COOKIE, HttpHeaderValue::toFullCookies)) {
            cookies.put(cookie.getName(), cookie);
        }
        this.parsedCookies = cookies;
        return this.parsedCookies;
    }

    @Nullable
    public HttpCookie getCookie(@NotNull String cookie) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        return this.getCookies().get(cookie);
    }

    private static void writeCodeMessage(@NotNull ByteBuf buf, int code) {
        byte[] result;
        switch (code) {
            case 100: {
                result = CODE_100_BYTES;
                break;
            }
            case 101: {
                result = CODE_101_BYTES;
                break;
            }
            case 102: {
                result = CODE_102_BYTES;
                break;
            }
            case 103: {
                result = CODE_103_BYTES;
                break;
            }
            case 200: {
                result = CODE_200_BYTES;
                break;
            }
            case 201: {
                result = CODE_201_BYTES;
                break;
            }
            case 202: {
                result = CODE_202_BYTES;
                break;
            }
            case 203: {
                result = CODE_203_BYTES;
                break;
            }
            case 204: {
                result = CODE_204_BYTES;
                break;
            }
            case 205: {
                result = CODE_205_BYTES;
                break;
            }
            case 206: {
                result = CODE_206_BYTES;
                break;
            }
            case 207: {
                result = CODE_207_BYTES;
                break;
            }
            case 208: {
                result = CODE_208_BYTES;
                break;
            }
            case 226: {
                result = CODE_226_BYTES;
                break;
            }
            case 300: {
                result = CODE_300_BYTES;
                break;
            }
            case 301: {
                result = CODE_301_BYTES;
                break;
            }
            case 302: {
                result = CODE_302_BYTES;
                break;
            }
            case 303: {
                result = CODE_303_BYTES;
                break;
            }
            case 304: {
                result = CODE_304_BYTES;
                break;
            }
            case 305: {
                result = CODE_305_BYTES;
                break;
            }
            case 307: {
                result = CODE_307_BYTES;
                break;
            }
            case 308: {
                result = CODE_308_BYTES;
                break;
            }
            case 400: {
                result = CODE_400_BYTES;
                break;
            }
            case 401: {
                result = CODE_401_BYTES;
                break;
            }
            case 402: {
                result = CODE_402_BYTES;
                break;
            }
            case 403: {
                result = CODE_403_BYTES;
                break;
            }
            case 404: {
                result = CODE_404_BYTES;
                break;
            }
            case 405: {
                result = CODE_405_BYTES;
                break;
            }
            case 406: {
                result = CODE_406_BYTES;
                break;
            }
            case 407: {
                result = CODE_407_BYTES;
                break;
            }
            case 408: {
                result = CODE_408_BYTES;
                break;
            }
            case 409: {
                result = CODE_409_BYTES;
                break;
            }
            case 410: {
                result = CODE_410_BYTES;
                break;
            }
            case 411: {
                result = CODE_411_BYTES;
                break;
            }
            case 412: {
                result = CODE_412_BYTES;
                break;
            }
            case 413: {
                result = CODE_413_BYTES;
                break;
            }
            case 414: {
                result = CODE_414_BYTES;
                break;
            }
            case 415: {
                result = CODE_415_BYTES;
                break;
            }
            case 416: {
                result = CODE_416_BYTES;
                break;
            }
            case 417: {
                result = CODE_417_BYTES;
                break;
            }
            case 421: {
                result = CODE_421_BYTES;
                break;
            }
            case 422: {
                result = CODE_422_BYTES;
                break;
            }
            case 423: {
                result = CODE_423_BYTES;
                break;
            }
            case 424: {
                result = CODE_424_BYTES;
                break;
            }
            case 425: {
                result = CODE_425_BYTES;
                break;
            }
            case 426: {
                result = CODE_426_BYTES;
                break;
            }
            case 428: {
                result = CODE_428_BYTES;
                break;
            }
            case 429: {
                result = CODE_429_BYTES;
                break;
            }
            case 431: {
                result = CODE_431_BYTES;
                break;
            }
            case 451: {
                result = CODE_451_BYTES;
                break;
            }
            case 500: {
                result = CODE_500_BYTES;
                break;
            }
            case 501: {
                result = CODE_501_BYTES;
                break;
            }
            case 502: {
                result = CODE_502_BYTES;
                break;
            }
            case 503: {
                result = CODE_503_BYTES;
                break;
            }
            case 504: {
                result = CODE_504_BYTES;
                break;
            }
            case 505: {
                result = CODE_505_BYTES;
                break;
            }
            case 506: {
                result = CODE_506_BYTES;
                break;
            }
            case 507: {
                result = CODE_507_BYTES;
                break;
            }
            case 508: {
                result = CODE_508_BYTES;
                break;
            }
            case 510: {
                result = CODE_510_BYTES;
                break;
            }
            case 511: {
                result = CODE_511_BYTES;
                break;
            }
            default: {
                HttpResponse.writeCodeMessage2(buf, code);
                return;
            }
        }
        buf.put(result);
    }

    private static void writeCodeMessage2(@NotNull ByteBuf buf, int code) {
        buf.put(HTTP11_BYTES);
        ByteBufStrings.putPositiveInt((ByteBuf)buf, (int)code);
        if (code >= 400) {
            buf.put(CODE_ERROR_BYTES);
        } else {
            buf.put(CODE_OK_BYTES);
        }
    }

    @Override
    protected int estimateSize() {
        return this.estimateSize(LONGEST_FIRST_LINE_SIZE);
    }

    @Override
    protected void writeTo(@NotNull ByteBuf buf) {
        if (CHECK) {
            Checks.checkState((!this.isRecycled() ? 1 : 0) != 0);
        }
        HttpResponse.writeCodeMessage(buf, this.code);
        this.writeHeaders(buf);
    }

    public String toString() {
        if (this.isRecycled()) {
            return "{Recycled HttpResponse}";
        }
        return HttpResponse.class.getSimpleName() + ": " + this.code;
    }

    @FunctionalInterface
    public static interface FileSliceSupplier {
        public Promise<ChannelSupplier<ByteBuf>> getFileSlice(long var1, long var3);
    }
}

