/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.callback.Callback;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.recycle.Recyclable;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.ChannelSuppliers;
import io.activej.eventloop.Eventloop;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.AsyncHttpServer;
import io.activej.http.AsyncServlet;
import io.activej.http.GzipProcessorUtils;
import io.activej.http.HttpHeader;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpMethod;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpVersion;
import io.activej.http.MalformedHttpException;
import io.activej.http.PoolLabel;
import io.activej.http.Protocol;
import io.activej.http.UrlParser;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketConstants;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.net.socket.tcp.AsyncTcpSocketSsl;
import io.activej.promise.Promise;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpServerConnection
extends AbstractHttpConnection {
    private static final boolean CHECK = Checks.isEnabled(HttpServerConnection.class);
    private static final boolean DETAILED_ERROR_MESSAGES = ApplicationSettings.getBoolean(HttpServerConnection.class, (String)"detailedErrorMessages", (boolean)false);
    private static final int INITIAL_WRITE_BUFFER_SIZE = ApplicationSettings.getMemSize(HttpServerConnection.class, (String)"initialWriteBufferSize", (MemSize)MemSize.ZERO).toInt();
    private static final HttpMethod[] METHODS = new HttpMethod[128];
    private final InetAddress remoteAddress;
    private final AsyncHttpServer server;
    private final AsyncServlet servlet;
    @Nullable
    private HttpRequest request;
    @Nullable
    private final AsyncHttpServer.Inspector inspector;
    @Nullable
    private ByteBuf writeBuf;
    private static final byte[] EXPECT_100_CONTINUE;
    private static final byte[] EXPECT_RESPONSE_CONTINUE;
    private static final byte[] MALFORMED_HTTP_RESPONSE;

    HttpServerConnection(Eventloop eventloop, AsyncTcpSocket asyncTcpSocket, InetAddress remoteAddress, AsyncHttpServer server, AsyncServlet servlet) {
        super(eventloop, asyncTcpSocket, server.maxBodySize);
        this.remoteAddress = remoteAddress;
        this.server = server;
        this.servlet = servlet;
        this.inspector = server.inspector;
    }

    void serve() {
        if (this.inspector != null) {
            this.inspector.onAccept(this);
        }
        this.pool = this.server.poolNew;
        this.pool.addLastNode(this);
        this.poolTimestamp = this.eventloop.currentTimeMillis();
        this.socket.read().run((Callback)this.readMessageConsumer);
    }

    public PoolLabel getCurrentPool() {
        if (this.pool == this.server.poolNew) {
            return PoolLabel.NEW;
        }
        if (this.pool == this.server.poolKeepAlive) {
            return PoolLabel.KEEP_ALIVE;
        }
        if (this.pool == this.server.poolReadWrite) {
            return PoolLabel.READ_WRITE;
        }
        if (this.pool == this.server.poolServing) {
            return PoolLabel.SERVING;
        }
        return PoolLabel.NONE;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    protected void readMessage() throws MalformedHttpException {
        do {
            this.contentLength = 0L;
            this.flags = (byte)64;
            this.readStartLine();
            if (!this.isClosed()) continue;
            return;
        } while ((this.flags & 0x31) == 49 && this.readBuf != null);
        this.flags = (byte)(this.flags & 0xFFFFFFBF);
        if (this.writeBuf != null) {
            ByteBuf writeBuf = this.writeBuf;
            this.writeBuf = null;
            this.writeBuf(writeBuf);
        } else if ((this.flags & 0x30) == 48) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onClosedWithError(@NotNull Exception e) {
        if (this.inspector != null) {
            this.inspector.onHttpError(this, e);
        }
    }

    @Override
    protected void onMalformedHttpException(@NotNull MalformedHttpException e) {
        if (this.inspector != null) {
            this.inspector.onMalformedHttpRequest(this, e, this.readBuf.getArray());
        }
        this.writeBuf = this.ensureWriteBuffer(MALFORMED_HTTP_RESPONSE.length);
        this.writeBuf.put(MALFORMED_HTTP_RESPONSE);
        ByteBuf writeBuf = this.writeBuf;
        this.writeBuf = null;
        this.socket.write(writeBuf).whenComplete(() -> this.closeEx(e));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onStartLine(byte[] line, int pos, int limit) throws MalformedHttpException {
        HttpVersion version;
        int urlStart;
        int urlEnd;
        HttpMethod method;
        block11: {
            block12: {
                int p;
                this.switchPool(this.server.poolReadWrite);
                method = HttpServerConnection.getHttpMethod(line, pos);
                if (method == null) {
                    if (!DETAILED_ERROR_MESSAGES) {
                        throw new MalformedHttpException("Unknown HTTP method");
                    }
                    throw new MalformedHttpException("Unknown HTTP method. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
                }
                for (urlEnd = urlStart = pos + method.size + 1; urlEnd < limit && line[urlEnd] != 32; ++urlEnd) {
                }
                for (p = urlEnd + 1; p < limit && line[p] == 32; ++p) {
                }
                if (p + 7 >= limit || line[p + 0] != 72 || line[p + 1] != 84 || line[p + 2] != 84 || line[p + 3] != 80 || line[p + 4] != 47 || line[p + 5] != 49 || line[p + 6] != 46) break block12;
                if (line[p + 7] == 49) {
                    this.flags = (byte)(this.flags | 1);
                    version = HttpVersion.HTTP_1_1;
                    break block11;
                } else if (line[p + 7] == 48) {
                    version = HttpVersion.HTTP_1_0;
                    break block11;
                } else {
                    if (!DETAILED_ERROR_MESSAGES) {
                        throw new MalformedHttpException("Unknown HTTP version");
                    }
                    throw new MalformedHttpException("Unknown HTTP version. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
                }
            }
            if (!DETAILED_ERROR_MESSAGES) {
                throw new MalformedHttpException("Unsupported HTTP version");
            }
            throw new MalformedHttpException("Unsupported HTTP version. First line: " + new String(line, 0, limit, StandardCharsets.ISO_8859_1));
        }
        this.request = new HttpRequest(version, method, UrlParser.parse(line, urlStart, urlEnd), this);
        this.request.maxBodySize = this.maxBodySize;
        if (method == HttpMethod.GET || method == HttpMethod.DELETE) {
            this.contentLength = 0L;
        }
    }

    private static HttpMethod getHttpMethod(byte[] line, int pos) {
        boolean get;
        boolean bl = get = line[pos] == 71 && line[pos + 1] == 69 && line[pos + 2] == 84 && (line[pos + 3] == 32 || line[pos + 3] == 9);
        if (get) {
            return HttpMethod.GET;
        }
        return HttpServerConnection.getHttpMethodFromMap(line, pos);
    }

    private static HttpMethod getHttpMethodFromMap(byte[] line, int pos) {
        int hashCode = 0;
        for (int i = pos; i < Math.min(pos + 10, line.length); ++i) {
            byte b = line[i];
            if (b == 32 || b == 9) {
                int slot = hashCode & METHODS.length - 1;
                HttpMethod method = METHODS[slot];
                return method != null && method.compareTo(line, pos, i - pos) ? method : null;
            }
            hashCode += b;
        }
        return null;
    }

    @Override
    protected void onHeader(HttpHeader header, byte[] array, int off, int len) throws MalformedHttpException {
        if (header == HttpHeaders.EXPECT && ByteBufStrings.equalsLowerCaseAscii((byte[])EXPECT_100_CONTINUE, (byte[])array, (int)off, (int)len)) {
            this.socket.write(ByteBuf.wrapForReading((byte[])EXPECT_RESPONSE_CONTINUE));
        }
        if (this.request.headers.size() >= MAX_HEADERS) {
            throw new MalformedHttpException("Too many headers");
        }
        this.request.addHeader(header, array, off, len);
    }

    private void writeHttpResponse(HttpResponse httpResponse) {
        ByteBuf writeBuf;
        boolean isWebSocket;
        boolean bl = isWebSocket = WebSocket.ENABLED && this.isWebSocket();
        if (!isWebSocket || httpResponse.getCode() != 101) {
            HttpHeaderValue connectionHeader;
            HttpHeaderValue httpHeaderValue = connectionHeader = (this.flags & 1) != 0 ? CONNECTION_KEEP_ALIVE_HEADER : CONNECTION_CLOSE_HEADER;
            if (this.server.keepAliveTimeoutMillis == 0 || this.numberOfRequests >= this.server.maxKeepAliveRequests && this.server.maxKeepAliveRequests != 0) {
                connectionHeader = CONNECTION_CLOSE_HEADER;
            }
            httpResponse.addHeader(HttpHeaders.CONNECTION, connectionHeader);
            if (isWebSocket) {
                this.flags = (byte)(this.flags & 0xFFFFFFF7);
            }
        }
        if (this.renderHttpResponse(httpResponse)) {
            if ((this.flags & 0x40) != 0) {
                this.flags = (byte)(this.flags | 0x20);
            } else {
                writeBuf = this.writeBuf;
                this.writeBuf = null;
                this.writeBuf(writeBuf);
            }
        } else {
            writeBuf = this.writeBuf;
            this.writeBuf = null;
            this.writeHttpMessageAsStream(writeBuf, httpResponse);
        }
    }

    boolean renderHttpResponse(HttpMessage httpMessage) {
        if (httpMessage.body != null) {
            ByteBuf body = httpMessage.body;
            httpMessage.body = null;
            if ((httpMessage.flags & 2) == 0) {
                httpMessage.addHeader(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(body.readRemaining()));
                int messageSize = httpMessage.estimateSize() + body.readRemaining();
                this.writeBuf = this.ensureWriteBuffer(messageSize);
                httpMessage.writeTo(this.writeBuf);
                this.writeBuf.put(body);
                body.recycle();
            } else {
                ByteBuf gzippedBody = GzipProcessorUtils.toGzip(body);
                httpMessage.addHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaderValue.ofBytes(CONTENT_ENCODING_GZIP));
                httpMessage.addHeader(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(gzippedBody.readRemaining()));
                int messageSize = httpMessage.estimateSize() + gzippedBody.readRemaining();
                this.writeBuf = this.ensureWriteBuffer(messageSize);
                httpMessage.writeTo(this.writeBuf);
                this.writeBuf.put(gzippedBody);
                gzippedBody.recycle();
            }
            return true;
        }
        if (httpMessage.bodyStream == null) {
            if (httpMessage.isContentLengthExpected()) {
                httpMessage.addHeader(HttpHeaders.CONTENT_LENGTH, HttpHeaderValue.ofDecimal(0));
            }
            this.writeBuf = this.ensureWriteBuffer(httpMessage.estimateSize());
            httpMessage.writeTo(this.writeBuf);
            return true;
        }
        return false;
    }

    private ByteBuf ensureWriteBuffer(int messageSize) {
        return this.writeBuf == null ? ByteBufPool.allocate((int)Math.max(messageSize, INITIAL_WRITE_BUFFER_SIZE)) : ByteBufPool.ensureWriteRemaining((ByteBuf)this.writeBuf, (int)messageSize);
    }

    @Override
    protected void onHeadersReceived(@Nullable ByteBuf body, @Nullable ChannelSupplier<ByteBuf> bodySupplier) {
        Promise servletResult;
        assert (!this.isClosed());
        this.request.flags = (byte)(this.request.flags | 1);
        this.request.body = body;
        ChannelSupplier channelSupplier = this.request.bodyStream = bodySupplier == null ? null : this.sanitize(bodySupplier);
        if (WebSocket.ENABLED && this.isWebSocket()) {
            if (!this.processWebSocketRequest(body)) {
                return;
            }
        } else {
            this.request.setProtocol(this.socket instanceof AsyncTcpSocketSsl ? Protocol.HTTPS : Protocol.HTTP);
        }
        this.request.setRemoteAddress(this.remoteAddress);
        ++this.numberOfRequests;
        if (this.inspector != null) {
            this.inspector.onHttpRequest(this.request);
        }
        this.switchPool(this.server.poolServing);
        HttpRequest request = this.request;
        try {
            servletResult = this.servlet.serveAsync(request);
        }
        catch (Exception e2) {
            servletResult = Promise.ofException((Exception)e2);
        }
        servletResult.run((response, e) -> {
            if (CHECK) {
                Checks.checkState((boolean)this.eventloop.inEventloopThread());
            }
            if (this.isClosed()) {
                request.recycle();
                this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
                this.stashedBufs = (Recyclable)Utils.nullify((Object)this.stashedBufs, Recyclable::recycle);
                if (response != null) {
                    response.recycleBody();
                }
                return;
            }
            this.switchPool(this.server.poolReadWrite);
            if (e == null) {
                if (this.inspector != null) {
                    this.inspector.onHttpResponse(request, (HttpResponse)response);
                }
                this.recycle();
                this.writeHttpResponse((HttpResponse)response);
            } else {
                if (this.inspector != null) {
                    this.inspector.onServletException(request, e);
                }
                this.recycle();
                this.writeException(e);
            }
        });
    }

    private void recycle() {
        if (this.stashedBufs != null) {
            this.stashedBufs.recycle();
            this.stashedBufs = null;
        }
        if (this.readBuf != null && !this.readBuf.canRead()) {
            this.readBuf.recycle();
            this.readBuf = null;
        }
        this.request.recycle();
    }

    private boolean processWebSocketRequest(@Nullable ByteBuf body) {
        if (body != null && body.readRemaining() == 0) {
            ChannelSupplier ofReadBufSupplier = ChannelSupplier.of((Object)this.detachReadBuf());
            ChannelSupplier ofSocketSupplier = ChannelSupplier.ofSocket((AsyncTcpSocket)this.socket);
            this.request.bodyStream = this.sanitize((ChannelSupplier<ByteBuf>)ChannelSuppliers.concat((ChannelSupplier)ofReadBufSupplier, (ChannelSupplier)ofSocketSupplier).withEndOfStream(eos -> eos.whenException(this::closeWebSocketConnection)));
            this.request.setProtocol(this.socket instanceof AsyncTcpSocketSsl ? Protocol.WSS : Protocol.WS);
            this.request.maxBodySize = this.server.maxWebSocketMessageSize;
            return true;
        }
        this.closeEx(WebSocketConstants.UPGRADE_WITH_BODY);
        return false;
    }

    @Override
    protected void onBodyReceived() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x10);
        if ((this.flags & 0x70) == 48 && this.pool != this.server.poolServing) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onBodySent() {
        assert (!this.isClosed());
        this.flags = (byte)(this.flags | 0x20);
        if ((this.flags & 0x70) == 48 && this.pool != this.server.poolServing) {
            this.onHttpMessageComplete();
        }
    }

    @Override
    protected void onNoContentLength() {
        throw new AssertionError((Object)"This method should not be called on a server");
    }

    private void onHttpMessageComplete() {
        assert (!this.isClosed());
        if (WebSocket.ENABLED && this.isWebSocket()) {
            return;
        }
        if ((this.flags & 1) != 0 && this.server.keepAliveTimeoutMillis != 0) {
            this.switchPool(this.server.poolKeepAlive);
            if (this.socket.isReadAvailable()) {
                this.socket.read().whenResult(buf -> {
                    this.readBuf = this.readBuf == null ? buf : ByteBufPool.append((ByteBuf)this.readBuf, (ByteBuf)buf);
                });
            }
            this.read();
        } else {
            this.close();
        }
    }

    private void writeException(Exception e) {
        this.writeHttpResponse(this.server.formatHttpError(e));
    }

    @Override
    protected void onClosed() {
        if (this.pool != this.server.poolServing) {
            this.request = (HttpRequest)Utils.nullify((Object)this.request, HttpMessage::recycle);
            this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
            this.stashedBufs = (Recyclable)Utils.nullify((Object)this.stashedBufs, Recyclable::recycle);
        }
        if (this.inspector != null) {
            this.inspector.onDisconnect(this);
        }
        this.pool.removeNode(this);
        if (!$assertionsDisabled) {
            this.pool = null;
            if (null != null) {
                throw new AssertionError();
            }
        }
        this.server.onConnectionClosed();
        this.writeBuf = (ByteBuf)Utils.nullify((Object)this.writeBuf, ByteBuf::recycle);
    }

    @Override
    public String toString() {
        return "HttpServerConnection{pool=" + (Object)((Object)this.getCurrentPool()) + ", remoteAddress=" + this.remoteAddress + ',' + super.toString() + '}';
    }

    static {
        assert (Integer.bitCount(METHODS.length) == 1);
        for (HttpMethod httpMethod : HttpMethod.values()) {
            int hashCode = 0;
            for (int i = 0; i < httpMethod.bytes.length; ++i) {
                hashCode += httpMethod.bytes[i];
            }
            int slot = hashCode & METHODS.length - 1;
            if (METHODS[slot] != null) {
                throw new IllegalArgumentException("HTTP METHODS hash collision, try to increase METHODS size");
            }
            HttpServerConnection.METHODS[slot] = httpMethod;
        }
        EXPECT_100_CONTINUE = ByteBufStrings.encodeAscii((String)"100-continue");
        EXPECT_RESPONSE_CONTINUE = ByteBufStrings.encodeAscii((String)"HTTP/1.1 100 Continue\r\n\r\n");
        MALFORMED_HTTP_RESPONSE = ByteBufStrings.encodeAscii((String)"HTTP/1.1 400 Bad Request\r\nConnection: close\r\nContent-Length: 0\r\n\r\n");
    }
}

