/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Utils;
import io.activej.http.CaseInsensitiveTokenMap;
import io.activej.http.HttpUtils;
import io.activej.http.MediaTypes;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class MediaType
extends CaseInsensitiveTokenMap.Token {
    MediaType(int hashCodeCI, byte[] bytes, int offset, int length, byte @Nullable [] lowerCaseBytes) {
        super(hashCodeCI, bytes, offset, length, lowerCaseBytes);
    }

    public static MediaType of(String mime) {
        byte[] bytes = ByteBufStrings.encodeAscii((String)mime);
        return MediaTypes.of(HttpUtils.hashCodeCI(bytes), bytes, 0, bytes.length);
    }

    int size() {
        return this.bytes.length;
    }

    public boolean isTextType() {
        return this.bytes.length > 5 && this.bytes[0] == 116 && this.bytes[1] == 101 && this.bytes[2] == 120 && this.bytes[3] == 116 && this.bytes[4] == 47;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType that = (MediaType)o;
        return Utils.arraysEquals((byte[])this.bytes, (int)this.offset, (int)this.length, (byte[])that.bytes, (int)that.offset, (int)that.length);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bytes);
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        return result;
    }

    public String toString() {
        return ByteBufStrings.decodeAscii((byte[])this.bytes, (int)this.offset, (int)this.length);
    }
}

