/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.ApplicationSettings;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.recycle.Recyclable;
import io.activej.common.ref.Ref;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelConsumers;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.binary.ByteBufsDecoder;
import io.activej.http.MalformedHttpException;
import io.activej.promise.Promise;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultipartDecoder
implements ByteBufsDecoder<MultipartFrame>,
WithInitializer<MultipartDecoder> {
    private static final int MAX_META_SIZE = ApplicationSettings.getMemSize(MultipartDecoder.class, (String)"maxMetaBuffer", (MemSize)MemSize.kilobytes((long)4L)).toInt();
    private static final ByteBufsDecoder<ByteBuf> OF_CRLF_DECODER = ByteBufsDecoder.ofCrlfTerminatedBytes();
    @Nullable
    private List<String> readingHeaders = null;
    private final byte[] boundary;
    private final byte[] lastBoundary;
    private boolean sawCrlf = true;
    private boolean finished = false;

    private MultipartDecoder(String boundary) {
        this.boundary = ("--" + boundary).getBytes(StandardCharsets.UTF_8);
        this.lastBoundary = ("--" + boundary + "--").getBytes(StandardCharsets.UTF_8);
    }

    public static MultipartDecoder create(String boundary) {
        return new MultipartDecoder(boundary);
    }

    public ByteBufsDecoder<ByteBuf> ignoreHeaders() {
        return bufs -> {
            MultipartFrame frame = this.tryDecode(bufs);
            if (frame == null || frame.isHeaders()) {
                return null;
            }
            return frame.getData();
        };
    }

    private Promise<Map<String, String>> getContentDispositionFields(MultipartFrame frame) {
        Map<String, String> headers = frame.getHeaders();
        assert (headers != null);
        String header = headers.get("content-disposition");
        if (header == null) {
            return Promise.ofException((Exception)new MalformedHttpException("Headers had no Content-Disposition"));
        }
        String[] headerParts = header.split(";");
        if (headerParts.length == 0 || !"form-data".equals(headerParts[0].trim())) {
            return Promise.ofException((Exception)new MalformedHttpException("Content-Disposition type is not 'form-data'"));
        }
        return Promise.of(Arrays.stream(headerParts).skip(1L).map(part -> part.trim().split("=", 2)).collect(Collectors.toMap(s -> s[0], s -> {
            String value = ((String[])s).length == 1 ? "" : s[1];
            return value.substring(1, value.length() - 1);
        })));
    }

    private Promise<Void> doSplit(MultipartFrame headerFrame, ChannelSupplier<MultipartFrame> frames, MultipartDataHandler dataHandler) {
        return this.getContentDispositionFields(headerFrame).then(contentDispositionFields -> {
            String fieldName = (String)contentDispositionFields.get("name");
            String fileName = (String)contentDispositionFields.get("filename");
            Ref lastRef = new Ref();
            return frames.until(f -> {
                if (f.isHeaders()) {
                    lastRef.set(f);
                    return true;
                }
                return false;
            }).filter(MultipartFrame::isData).map(MultipartFrame::getData).streamTo(ChannelConsumer.ofPromise(fileName == null ? dataHandler.handleField(fieldName) : dataHandler.handleFile(fieldName, fileName))).then(() -> lastRef.get() != null ? this.doSplit((MultipartFrame)lastRef.get(), frames, dataHandler) : Promise.complete()).toVoid();
        });
    }

    public Promise<Void> split(ChannelSupplier<ByteBuf> source, MultipartDataHandler dataHandler) {
        ChannelSupplier frames = BinaryChannelSupplier.of(source).decodeStream((ByteBufsDecoder)this);
        return frames.get().thenIfNonNull(frame -> {
            if (frame.isHeaders()) {
                return this.doSplit((MultipartFrame)frame, (ChannelSupplier<MultipartFrame>)frames, dataHandler);
            }
            MalformedHttpException e = new MalformedHttpException("First frame had no headers");
            frames.closeEx((Exception)e);
            return Promise.ofException((Exception)e);
        });
    }

    @Nullable
    public MultipartFrame tryDecode(ByteBufs bufs) throws MalformedDataException {
        int toTake;
        ByteBuf buf;
        if (this.finished) {
            return null;
        }
        while ((buf = (ByteBuf)OF_CRLF_DECODER.tryDecode(bufs)) != null) {
            if (this.sawCrlf) {
                if (this.readingHeaders == null) {
                    if (buf.isContentEqual(this.lastBoundary)) {
                        this.finished = true;
                        buf.recycle();
                        continue;
                    }
                    if (buf.isContentEqual(this.boundary)) {
                        buf.recycle();
                        this.readingHeaders = new ArrayList<String>();
                        continue;
                    }
                    return this.getFalseTermFrame(buf);
                }
                if (buf.canRead()) {
                    this.readingHeaders.add(buf.asString(StandardCharsets.UTF_8));
                    continue;
                }
                this.sawCrlf = false;
                buf.recycle();
                List<String> readingHeaders = this.readingHeaders;
                this.readingHeaders = null;
                if (readingHeaders.isEmpty()) break;
                return MultipartFrame.of(readingHeaders.stream().map(s -> s.split(":\\s?", 2)).collect(Collectors.toMap(s -> s[0].toLowerCase(), s -> s[1])));
            }
            this.sawCrlf = true;
            return MultipartFrame.of(buf);
        }
        int remaining = bufs.remainingBytes();
        if (this.sawCrlf) {
            if (this.readingHeaders == null && this.cannotBeBoundary(bufs)) {
                this.sawCrlf = false;
                return this.getFalseTermFrame(bufs.takeRemaining());
            }
            if (remaining >= MAX_META_SIZE) {
                throw new InvalidSizeException("Header size exceeds max meta size");
            }
            return null;
        }
        int n = remaining == 0 ? 0 : (toTake = remaining - (bufs.peekByte(remaining - 1) == 13 ? 1 : 0));
        if (toTake == 0) {
            return null;
        }
        ByteBuf data = bufs.takeExactSize(toTake);
        return MultipartFrame.of(data);
    }

    @NotNull
    private MultipartFrame getFalseTermFrame(ByteBuf term) {
        ByteBuf buf = ByteBufPool.allocate((int)(term.readRemaining() + 2));
        buf.writeByte((byte)13);
        buf.writeByte((byte)10);
        term.drainTo(buf, term.readRemaining());
        term.recycle();
        return MultipartFrame.of(buf);
    }

    private boolean cannotBeBoundary(ByteBufs bufs) throws MalformedDataException {
        return bufs.scanBytes((index, nextByte) -> {
            if (index == this.lastBoundary.length) {
                return nextByte != 13;
            }
            if (index == this.lastBoundary.length - 1) {
                return nextByte != 45;
            }
            if (index == this.boundary.length) {
                return nextByte != 45 && nextByte != 13;
            }
            assert (index < this.boundary.length);
            return nextByte != this.boundary[index];
        }) != 0;
    }

    public static final class MultipartFrame
    implements Recyclable {
        @Nullable
        private ByteBuf data;
        @Nullable
        private final Map<String, String> headers;

        private MultipartFrame(@Nullable ByteBuf data, @Nullable Map<String, String> headers) {
            this.data = data;
            this.headers = headers;
        }

        public static MultipartFrame of(ByteBuf data) {
            return new MultipartFrame(data, null);
        }

        public static MultipartFrame of(Map<String, String> headers) {
            return new MultipartFrame(null, headers);
        }

        public boolean isData() {
            return this.data != null;
        }

        public ByteBuf getData() {
            return this.data;
        }

        public boolean isHeaders() {
            return this.headers != null;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void recycle() {
            this.data = (ByteBuf)Utils.nullify((Object)this.data, ByteBuf::recycle);
        }

        public String toString() {
            return this.isHeaders() ? "headers" + this.headers : "" + this.data;
        }
    }

    public static interface MultipartDataHandler {
        public Promise<? extends ChannelConsumer<ByteBuf>> handleField(String var1);

        public Promise<? extends ChannelConsumer<ByteBuf>> handleFile(String var1, String var2);

        public static MultipartDataHandler fieldsToMap(Map<String, String> fields) {
            return MultipartDataHandler.fieldsToMap(fields, (String $1, String $2) -> Promise.of((Object)ChannelConsumers.recycling()));
        }

        public static MultipartDataHandler fieldsToMap(Map<String, String> fields, Function<String, Promise<? extends ChannelConsumer<ByteBuf>>> uploader) {
            return MultipartDataHandler.fieldsToMap(fields, (String $, String fileName) -> (Promise)uploader.apply((String)fileName));
        }

        public static MultipartDataHandler fieldsToMap(final Map<String, String> fields, final BiFunction<String, String, Promise<? extends ChannelConsumer<ByteBuf>>> uploader) {
            return new MultipartDataHandler(){

                @Override
                public Promise<? extends ChannelConsumer<ByteBuf>> handleField(String fieldName) {
                    return Promise.of((Object)ChannelConsumer.ofSupplier(supplier -> supplier.toCollector(ByteBufs.collector()).map(value -> {
                        fields.put(fieldName, value.asString(StandardCharsets.UTF_8));
                        return null;
                    })));
                }

                @Override
                public Promise<? extends ChannelConsumer<ByteBuf>> handleFile(String fieldName, String fileName) {
                    return (Promise)uploader.apply(fieldName, fileName);
                }
            };
        }

        public static MultipartDataHandler file(Function<String, Promise<? extends ChannelConsumer<ByteBuf>>> uploader) {
            return MultipartDataHandler.files(($, fileName) -> (Promise)uploader.apply((String)fileName));
        }

        public static MultipartDataHandler files(final BiFunction<String, String, Promise<? extends ChannelConsumer<ByteBuf>>> uploader) {
            return new MultipartDataHandler(){

                @Override
                public Promise<? extends ChannelConsumer<ByteBuf>> handleField(String fieldName) {
                    return Promise.of((Object)ChannelConsumers.recycling());
                }

                @Override
                public Promise<? extends ChannelConsumer<ByteBuf>> handleFile(String fieldName, String fileName) {
                    return (Promise)uploader.apply(fieldName, fileName);
                }
            };
        }
    }
}

