/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpError;
import io.activej.http.HttpMethod;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.Protocol;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketServlet;
import io.activej.promise.Promise;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoutingServlet
implements AsyncServlet,
WithInitializer<RoutingServlet> {
    private static final String ROOT = "/";
    private static final String STAR = "*";
    private static final String WILDCARD = "/*";
    private static final int WS_ORDINAL = HttpMethod.values().length;
    private static final int ANY_HTTP_ORDINAL = WS_ORDINAL + 1;
    private final AsyncServlet[] rootServlets = new AsyncServlet[ANY_HTTP_ORDINAL + 1];
    private final AsyncServlet[] fallbackServlets = new AsyncServlet[ANY_HTTP_ORDINAL + 1];
    private final Map<String, RoutingServlet> routes = new HashMap<String, RoutingServlet>();
    private final Map<String, RoutingServlet> parameters = new HashMap<String, RoutingServlet>();

    private RoutingServlet() {
    }

    public static RoutingServlet create() {
        return new RoutingServlet();
    }

    public static RoutingServlet wrap(AsyncServlet servlet) {
        RoutingServlet wrapper = new RoutingServlet();
        wrapper.fallbackServlets[RoutingServlet.ANY_HTTP_ORDINAL] = servlet;
        return wrapper;
    }

    public RoutingServlet map(@NotNull String path, @NotNull AsyncServlet servlet) {
        return this.map(null, path, servlet);
    }

    @Contract(value="_, _, _ -> this")
    public RoutingServlet map(@Nullable HttpMethod method, @NotNull String path, @NotNull AsyncServlet servlet) {
        return this.doMap(method == null ? ANY_HTTP_ORDINAL : method.ordinal(), path, servlet);
    }

    @Contract(value="_, _ -> this")
    public RoutingServlet mapWebSocket(@NotNull String path, final Consumer<WebSocket> webSocketConsumer) {
        return this.mapWebSocket(path, new WebSocketServlet(){

            @Override
            protected void onWebSocket(WebSocket webSocket) {
                webSocketConsumer.accept(webSocket);
            }
        });
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public RoutingServlet mapWebSocket(@NotNull String path, WebSocketServlet servlet) {
        return this.doMap(WS_ORDINAL, path, servlet);
    }

    @Contract(value="_, _, _ -> this")
    private RoutingServlet doMap(int ordinal, @NotNull String path, @NotNull AsyncServlet servlet) {
        Checks.checkArgument((path.startsWith(ROOT) && (path.endsWith(WILDCARD) || !path.contains(STAR)) ? 1 : 0) != 0, (Object)("Invalid path: " + path));
        if (path.endsWith(WILDCARD)) {
            this.makeSubtree(path.substring(0, path.length() - 2)).mapFallback(ordinal, servlet);
        } else {
            this.makeSubtree(path).map(ordinal, servlet);
        }
        return this;
    }

    public void visit(Visitor visitor) {
        this.visit(ROOT, visitor);
    }

    private void visit(String prefix, Visitor visitor) {
        HttpMethod method;
        int i;
        for (i = 0; i < this.rootServlets.length; ++i) {
            AsyncServlet rootServlet = this.rootServlets[i];
            if (rootServlet == null) continue;
            method = i == WS_ORDINAL || i == ANY_HTTP_ORDINAL ? null : HttpMethod.values()[i];
            visitor.accept(method, prefix, rootServlet);
        }
        for (i = 0; i < this.fallbackServlets.length; ++i) {
            AsyncServlet fallbackServlet = this.fallbackServlets[i];
            if (fallbackServlet == null) continue;
            method = i == WS_ORDINAL || i == ANY_HTTP_ORDINAL ? null : HttpMethod.values()[i];
            visitor.accept(method, prefix, fallbackServlet);
        }
        this.routes.forEach((route, subtree) -> subtree.visit(prefix + route + ROOT, visitor));
        this.parameters.forEach((route, subtree) -> subtree.visit(prefix + ":" + route + ROOT, visitor));
    }

    @Nullable
    public RoutingServlet getSubtree(String path) {
        return this.getOrCreateSubtree(path, (servlet, name) -> name.startsWith(":") ? servlet.parameters.get(name.substring(1)) : servlet.routes.get(name));
    }

    @Contract(value="_ -> new")
    public RoutingServlet merge(RoutingServlet servlet) {
        return this.merge(ROOT, servlet);
    }

    @Contract(value="_, _ -> new")
    public RoutingServlet merge(String path, RoutingServlet servlet) {
        RoutingServlet merged = new RoutingServlet();
        RoutingServlet.mergeInto(merged, this);
        RoutingServlet.mergeInto(merged.makeSubtree(path), servlet);
        return merged;
    }

    @NotNull
    public Promise<HttpResponse> serve(@NotNull HttpRequest request) throws Exception {
        Promise processed = this.tryServe(request);
        return processed != null ? processed : Promise.ofException((Exception)HttpError.notFound404());
    }

    private void map(int ordinal, @NotNull AsyncServlet servlet) {
        this.doMerge(this.rootServlets, ordinal, servlet);
    }

    private void mapFallback(int ordinal, @NotNull AsyncServlet servlet) {
        this.doMerge(this.fallbackServlets, ordinal, servlet);
    }

    private void doMerge(AsyncServlet[] servlets, int ordinal, AsyncServlet servlet) {
        if (servlets[ordinal] != null) {
            throw new IllegalArgumentException("Already mapped");
        }
        servlets[ordinal] = servlet;
    }

    @Nullable
    private Promise<HttpResponse> tryServe(HttpRequest request) throws Exception {
        AsyncServlet servlet;
        int ordinal;
        int introPosition = request.getPos();
        String urlPart = request.pollUrlPart();
        if (urlPart == null) {
            throw HttpError.badRequest400("Path contains bad percent encoding");
        }
        Protocol protocol = request.getProtocol();
        int n = ordinal = protocol == Protocol.WS || protocol == Protocol.WSS ? WS_ORDINAL : request.getMethod().ordinal();
        if (urlPart.isEmpty()) {
            servlet = RoutingServlet.getOrDefault(this.rootServlets, ordinal);
            if (servlet != null) {
                return servlet.serveAsync(request);
            }
        } else {
            int position = request.getPos();
            RoutingServlet transit = this.routes.get(urlPart);
            if (transit != null) {
                Promise<HttpResponse> result = transit.tryServe(request);
                if (result != null) {
                    return result;
                }
                request.setPos(position);
            }
            for (Map.Entry<String, RoutingServlet> entry : this.parameters.entrySet()) {
                String key = entry.getKey();
                request.putPathParameter(key, urlPart);
                Promise<HttpResponse> result = entry.getValue().tryServe(request);
                if (result != null) {
                    return result;
                }
                request.removePathParameter(key);
                request.setPos(position);
            }
        }
        if ((servlet = RoutingServlet.getOrDefault(this.fallbackServlets, ordinal)) != null) {
            request.setPos(introPosition);
            return servlet.serveAsync(request);
        }
        return null;
    }

    private RoutingServlet makeSubtree(String path) {
        return this.getOrCreateSubtree(path, (servlet, name) -> name.startsWith(":") ? servlet.parameters.computeIfAbsent(name.substring(1), $ -> new RoutingServlet()) : servlet.routes.computeIfAbsent((String)name, $ -> new RoutingServlet()));
    }

    private RoutingServlet getOrCreateSubtree(@NotNull String path, BiFunction<RoutingServlet, String, @Nullable RoutingServlet> childGetter) {
        if (path.isEmpty() || path.equals(ROOT)) {
            return this;
        }
        RoutingServlet sub = this;
        int slash = path.indexOf(47, 1);
        String remainingPath = path;
        while (true) {
            String urlPart;
            if (!(urlPart = remainingPath.substring(1, slash == -1 ? remainingPath.length() : slash)).startsWith(":")) {
                urlPart = RoutingServlet.decodePattern(urlPart);
            }
            if (urlPart.isEmpty()) {
                return sub;
            }
            sub = childGetter.apply(sub, urlPart);
            if (slash == -1 || sub == null) {
                return sub;
            }
            remainingPath = remainingPath.substring(slash);
            slash = remainingPath.indexOf(47, 1);
        }
    }

    public static RoutingServlet merge(RoutingServlet first, RoutingServlet second) {
        RoutingServlet merged = new RoutingServlet();
        RoutingServlet.mergeInto(merged, first);
        RoutingServlet.mergeInto(merged, second);
        return merged;
    }

    public static RoutingServlet merge(RoutingServlet ... servlets) {
        RoutingServlet merged = new RoutingServlet();
        for (RoutingServlet servlet : servlets) {
            RoutingServlet.mergeInto(merged, servlet);
        }
        return merged;
    }

    private static void mergeInto(RoutingServlet into, RoutingServlet from) {
        int i;
        for (i = 0; i < from.rootServlets.length; ++i) {
            AsyncServlet rootServlet = from.rootServlets[i];
            if (rootServlet == null) continue;
            into.map(i, rootServlet);
        }
        for (i = 0; i < from.fallbackServlets.length; ++i) {
            AsyncServlet fallbackServlet = from.fallbackServlets[i];
            if (fallbackServlet == null) continue;
            into.mapFallback(i, fallbackServlet);
        }
        from.routes.forEach((key, value) -> into.routes.merge((String)key, (RoutingServlet)value, (s1, s2) -> {
            RoutingServlet.mergeInto(s1, s2);
            return s1;
        }));
        from.parameters.forEach((key, value) -> into.parameters.merge((String)key, (RoutingServlet)value, (s1, s2) -> {
            RoutingServlet.mergeInto(s1, s2);
            return s1;
        }));
    }

    @Nullable
    private static AsyncServlet getOrDefault(AsyncServlet[] servlets, int ordinal) {
        AsyncServlet maybeResult = servlets[ordinal];
        if (maybeResult != null || ordinal == WS_ORDINAL) {
            return maybeResult;
        }
        return servlets[ANY_HTTP_ORDINAL];
    }

    private static String decodePattern(String pattern) {
        try {
            return URLDecoder.decode(pattern, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Pattern contains bad percent encoding", e);
        }
    }

    @FunctionalInterface
    public static interface Visitor {
        public void accept(@Nullable HttpMethod var1, String var2, AsyncServlet var3);
    }
}

