/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.csp.ChannelSupplier;
import io.activej.eventloop.Eventloop;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.IAsyncHttpClient;
import io.activej.promise.Promise;

public final class StubHttpClient
implements IAsyncHttpClient {
    private final AsyncServlet servlet;

    private StubHttpClient(AsyncServlet servlet) {
        this.servlet = servlet;
    }

    public static StubHttpClient of(AsyncServlet servlet) {
        return new StubHttpClient(servlet);
    }

    @Override
    public Promise<HttpResponse> request(HttpRequest request) {
        Promise servletResult;
        try {
            servletResult = this.servlet.serveAsync(request);
        }
        catch (Exception e) {
            servletResult = Promise.ofException((Exception)e);
        }
        return servletResult.whenComplete(request::recycleBody).then(res -> {
            ChannelSupplier bodyStream = res.bodyStream;
            Eventloop eventloop = Eventloop.getCurrentEventloop();
            if (bodyStream != null) {
                res.setBodyStream((ChannelSupplier<ByteBuf>)bodyStream.withEndOfStream(eos -> eos.whenComplete(() -> eventloop.post(res::recycle))));
            } else {
                eventloop.post(res::recycle);
            }
            return Promise.of((Object)res);
        });
    }
}

