/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.common.Checks;
import io.activej.http.HttpPathPart;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UrlBuilder {
    @Nullable
    private final String scheme;
    private final List<String> path = new LinkedList<String>();
    private final Map<String, String> query = new LinkedHashMap<String, String>();
    @Nullable
    private String userInfo;
    @Nullable
    private String host;
    @Nullable
    private String port;
    @Nullable
    private String fragment;

    private UrlBuilder(@Nullable String scheme) {
        this.scheme = scheme;
    }

    public static UrlBuilder of(String scheme) {
        return new UrlBuilder(scheme);
    }

    public static UrlBuilder http() {
        return new UrlBuilder("http");
    }

    public static UrlBuilder https() {
        return new UrlBuilder("https");
    }

    public UrlBuilder withAuthority(String userInfo, InetSocketAddress address) {
        String host;
        if (address.isUnresolved()) {
            host = address.getHostName();
        } else {
            InetAddress inetAddress = address.getAddress();
            host = inetAddress.getHostAddress();
            if (inetAddress instanceof Inet6Address) {
                host = '[' + host.replace("%", "%25") + ']';
            }
        }
        return this.withAuthority(userInfo, host, address.getPort());
    }

    public UrlBuilder withAuthority(String host) {
        this.host = host;
        return this;
    }

    public UrlBuilder withAuthority(String host, int port) {
        Checks.checkArgument((port >= 0 && port <= 49151 ? 1 : 0) != 0, (Object)"Port should in range [0, 49151]");
        this.port = Integer.toString(port);
        return this.withAuthority(host);
    }

    public UrlBuilder withAuthority(String userInfo, String host) {
        this.userInfo = userInfo;
        return this.withAuthority(host);
    }

    public UrlBuilder withAuthority(String userInfo, String host, int port) {
        this.userInfo = userInfo;
        return this.withAuthority(host, port);
    }

    public UrlBuilder withAuthority(InetSocketAddress address) {
        return this.withAuthority(address.isUnresolved() ? address.getHostName() : address.getAddress().getHostAddress(), address.getPort());
    }

    public static UrlBuilder relative() {
        return new UrlBuilder(null);
    }

    public static String mapToQuery(Map<String, ?> query) {
        StringBuilder sb = new StringBuilder();
        query.forEach((k, v) -> sb.append(UrlBuilder.urlEncode(k)).append('=').append(UrlBuilder.urlEncode(v.toString())).append('&'));
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public UrlBuilder appendPathPart(String part) {
        this.path.add(part);
        return this;
    }

    public UrlBuilder appendPathPart(HttpPathPart pathPart) {
        this.path.add(pathPart.toString());
        return this;
    }

    public UrlBuilder appendPath(String pathTail) {
        this.path.addAll(Arrays.asList(pathTail.split("/")));
        return this;
    }

    public UrlBuilder appendQuery(String key, Object value) {
        this.query.put(key, value.toString());
        return this;
    }

    public UrlBuilder withFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Apparently, UTF-8 no longer exists", e);
        }
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.host != null) {
            sb.append("//");
            if (this.userInfo != null) {
                sb.append(this.userInfo).append('@');
            }
            sb.append(this.host);
            if (this.port != null) {
                sb.append(':').append(this.port);
            }
            sb.append('/');
        }
        if (!this.path.isEmpty()) {
            this.path.forEach(p -> sb.append(UrlBuilder.urlEncode(p)).append('/'));
            sb.setLength(sb.length() - 1);
        }
        if (!this.query.isEmpty()) {
            sb.append('?');
            this.query.forEach((k, v) -> sb.append(UrlBuilder.urlEncode(k)).append('=').append(UrlBuilder.urlEncode(v)).append('&'));
            sb.setLength(sb.length() - 1);
        }
        if (this.fragment != null) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }
}

