/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.function.AsyncRunnable;
import io.activej.async.function.AsyncSupplier;
import io.activej.async.process.AbstractAsyncCloseable;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.common.recycle.Recyclable;
import io.activej.common.ref.Ref;
import io.activej.csp.AbstractChannelConsumer;
import io.activej.csp.AbstractChannelSupplier;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.ChannelSuppliers;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketConstants;
import io.activej.http.WebSocketException;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import io.activej.promise.SettablePromise;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WebSocketImpl
extends AbstractAsyncCloseable
implements WebSocket {
    private static final boolean CHECK = Checks.isEnabled(WebSocketImpl.class);
    private final HttpRequest request;
    private final HttpResponse response;
    private final Consumer<WebSocketException> onProtocolError;
    private final ChannelSupplier<WebSocket.Frame> frameInput;
    private final ChannelConsumer<WebSocket.Frame> frameOutput;
    private final int maxMessageSize;
    @Nullable
    private SettablePromise<?> readPromise;
    @Nullable
    private SettablePromise<Void> writePromise;

    WebSocketImpl(HttpRequest request, HttpResponse response, ChannelSupplier<WebSocket.Frame> frameInput, ChannelConsumer<WebSocket.Frame> frameOutput, Consumer<WebSocketException> onProtocolError, int maxMessageSize) {
        this.request = request;
        this.response = response;
        this.frameInput = ChannelSuppliers.prefetch(this.sanitize(frameInput));
        this.frameOutput = this.sanitize(frameOutput);
        this.onProtocolError = onProtocolError;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    @NotNull
    public Promise<WebSocket.Message> readMessage() {
        return this.doRead(() -> {
            ByteBufs messageBufs = new ByteBufs();
            Ref typeRef = new Ref();
            return Promises.repeat(() -> this.frameInput.get().then(frame -> {
                if (frame == null) {
                    if (typeRef.get() == null) {
                        return Promise.of((Object)false);
                    }
                    return Promise.ofException((Exception)WebSocketConstants.REGULAR_CLOSE);
                }
                if (typeRef.get() == null) {
                    typeRef.set((Object)HttpUtils.frameToMessageType(frame.getType()));
                }
                ByteBuf payload = frame.getPayload();
                if (messageBufs.remainingBytes() + payload.readRemaining() > this.maxMessageSize) {
                    return this.protocolError(WebSocketConstants.MESSAGE_TOO_BIG);
                }
                messageBufs.add(payload);
                return Promise.of((Object)(!frame.isLastFrame() ? 1 : 0));
            })).whenException(e -> messageBufs.recycle()).then($ -> {
                ByteBuf payload = messageBufs.takeRemaining();
                WebSocket.Message.MessageType type = (WebSocket.Message.MessageType)((Object)((Object)((Object)typeRef.get())));
                if (type == WebSocket.Message.MessageType.TEXT) {
                    try {
                        Promise promise = Promise.of((Object)WebSocket.Message.text(HttpUtils.getUTF8(payload)));
                        return promise;
                    }
                    catch (CharacterCodingException e) {
                        Promise promise = this.protocolError(WebSocketConstants.NOT_A_VALID_UTF_8);
                        return promise;
                    }
                    finally {
                        payload.recycle();
                    }
                }
                if (type == WebSocket.Message.MessageType.BINARY) {
                    return Promise.of((Object)WebSocket.Message.binary(payload));
                }
                return Promise.of(null);
            });
        });
    }

    @Override
    @NotNull
    public Promise<WebSocket.Frame> readFrame() {
        return this.doRead(() -> this.frameInput.get());
    }

    @Override
    @NotNull
    public Promise<Void> writeMessage(@Nullable WebSocket.Message msg) {
        return this.doWrite(() -> {
            if (msg == null) {
                return this.frameOutput.accept(null);
            }
            if (msg.getType() == WebSocket.Message.MessageType.TEXT) {
                return this.frameOutput.accept((Object)WebSocket.Frame.text(ByteBuf.wrapForReading((byte[])msg.getText().getBytes(StandardCharsets.UTF_8))));
            }
            return this.frameOutput.accept((Object)WebSocket.Frame.binary(msg.getBuf()));
        }, msg);
    }

    @Override
    @NotNull
    public Promise<Void> writeFrame(@Nullable WebSocket.Frame frame) {
        return this.doWrite(() -> this.frameOutput.accept((Object)frame), frame);
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    protected void onClosed(@NotNull Exception e) {
        this.frameOutput.closeEx(e);
        this.frameInput.closeEx(e);
        this.readPromise = (SettablePromise)Utils.nullify(this.readPromise, SettablePromise::setException, (Object)e);
        this.writePromise = (SettablePromise)Utils.nullify(this.writePromise, SettablePromise::setException, (Object)e);
    }

    protected void onCleanup() {
        this.request.recycle();
        this.response.recycle();
    }

    private <T> Promise<T> protocolError(WebSocketException exception) {
        this.onProtocolError.accept(exception);
        this.closeEx(exception);
        return Promise.ofException((Exception)exception);
    }

    private <T> Promise<T> doRead(AsyncSupplier<T> supplier) {
        SettablePromise readPromise;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
            Checks.checkState((this.readPromise == null ? 1 : 0) != 0, (Object)"Concurrent reads");
        }
        if (this.isClosed()) {
            return Promise.ofException((Exception)this.getException());
        }
        this.readPromise = readPromise = new SettablePromise();
        supplier.get().run((result, e) -> {
            this.readPromise = null;
            readPromise.trySet(result, e);
        });
        return readPromise;
    }

    private Promise<Void> doWrite(AsyncRunnable runnable, @Nullable Recyclable recyclable) {
        SettablePromise writePromise;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
            Checks.checkState((this.writePromise == null ? 1 : 0) != 0, (Object)"Concurrent writes");
        }
        if (this.isClosed()) {
            if (recyclable != null) {
                recyclable.recycle();
            }
            return Promise.ofException((Exception)this.getException());
        }
        this.writePromise = writePromise = new SettablePromise();
        runnable.run().run((result, e) -> {
            this.writePromise = null;
            writePromise.trySet(result, e);
        });
        return writePromise;
    }

    private ChannelSupplier<WebSocket.Frame> sanitize(final ChannelSupplier<WebSocket.Frame> supplier) {
        return new AbstractChannelSupplier<WebSocket.Frame>(supplier){

            protected Promise<WebSocket.Frame> doGet() {
                return this.sanitize(supplier.get());
            }

            protected void onClosed(@NotNull Exception e) {
                WebSocketImpl.this.closeEx(e);
            }
        };
    }

    private ChannelConsumer<WebSocket.Frame> sanitize(final ChannelConsumer<WebSocket.Frame> consumer) {
        return new AbstractChannelConsumer<WebSocket.Frame>(consumer){

            protected Promise<Void> doAccept(@Nullable WebSocket.Frame value) {
                return this.sanitize(consumer.accept((Object)value));
            }

            protected void onClosed(@NotNull Exception e) {
                WebSocketImpl.this.closeEx(e);
            }
        };
    }
}

