/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.http.loader.StaticLoader;
import io.activej.promise.Promise;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

class StaticLoaderClassPath
implements StaticLoader {
    private static final String ROOT = "/";
    private static final int ROOT_OFFSET = 1;
    @NotNull
    private final Executor executor;
    private final ClassLoader classLoader;
    private final String root;

    private StaticLoaderClassPath(@NotNull Executor executor, @NotNull ClassLoader classLoader, @NotNull String root) {
        this.root = root;
        this.executor = executor;
        this.classLoader = classLoader;
    }

    public static StaticLoaderClassPath create(@NotNull Executor executor, String root) {
        return StaticLoaderClassPath.create(executor, Thread.currentThread().getContextClassLoader(), root);
    }

    public static StaticLoaderClassPath create(@NotNull Executor executor, @NotNull ClassLoader classLoader, @NotNull String root) {
        if (root.startsWith(ROOT)) {
            root = root.substring(1);
        }
        if (!root.endsWith(ROOT) && root.length() > 0) {
            root = root + ROOT;
        }
        return new StaticLoaderClassPath(executor, classLoader, root);
    }

    @Override
    public Promise<ByteBuf> load(String name) {
        String path = this.root;
        int begin = 0;
        if (name.startsWith(ROOT)) {
            ++begin;
        }
        String finalPath = path = path + name.substring(begin);
        return Promise.ofBlocking((Executor)this.executor, () -> {
            Path filePath;
            URL resource = this.classLoader.getResource(finalPath);
            if (resource == null) {
                throw new ResourceNotFoundException("Could not find '" + name + "' in class path");
            }
            URLConnection connection = resource.openConnection();
            if (connection instanceof JarURLConnection) {
                if (((JarURLConnection)connection).getJarEntry().isDirectory()) {
                    throw new ResourceIsADirectoryException("Resource '" + name + "' is a directory");
                }
            } else if ("file".equals(resource.getProtocol()) && !Files.isRegularFile(filePath = Paths.get(resource.toURI()), new LinkOption[0])) {
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    throw new ResourceIsADirectoryException("Resource '" + name + "' is a directory");
                }
                throw new ResourceNotFoundException("Could not find '" + name + "' in class path");
            }
            return ByteBuf.wrapForReading((byte[])this.loadResource(connection));
        });
    }

    private byte[] loadResource(URLConnection connection) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        try (InputStream stream = connection.getInputStream();){
            int size;
            while ((size = stream.read(buffer)) != -1) {
                out.write(buffer, 0, size);
            }
        }
        return out.toByteArray();
    }
}

