/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.initializers;

import io.activej.config.Config;
import io.activej.config.converter.ConfigConverter;
import io.activej.csp.process.frames.FrameFormat;
import io.activej.csp.process.frames.FrameFormats;
import io.activej.csp.process.frames.LZ4FrameFormat;
import io.activej.csp.process.frames.LZ4LegacyFrameFormat;
import io.activej.dns.DnsCache;
import io.activej.eventloop.Eventloop;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigConverters {
    public static ConfigConverter<DnsCache> ofDnsCache(final Eventloop eventloop) {
        return new ConfigConverter<DnsCache>(){

            @NotNull
            public DnsCache get(Config config) {
                Duration errorCacheExpiration = (Duration)config.get(io.activej.config.converter.ConfigConverters.ofDuration(), "errorCacheExpiration", (Object)DnsCache.DEFAULT_ERROR_CACHE_EXPIRATION);
                Duration timedOutExceptionTtl = (Duration)config.get(io.activej.config.converter.ConfigConverters.ofDuration(), "timedOutExpiration", (Object)DnsCache.DEFAULT_TIMED_OUT_EXPIRATION);
                Duration hardExpirationDelta = (Duration)config.get(io.activej.config.converter.ConfigConverters.ofDuration(), "hardExpirationDelta", (Object)DnsCache.DEFAULT_HARD_EXPIRATION_DELTA);
                Duration maxTtl = (Duration)config.get(io.activej.config.converter.ConfigConverters.ofDuration(), "maxTtl", (Object)DnsCache.DEFAULT_MAX_TTL);
                return DnsCache.create((Eventloop)eventloop).withErrorCacheExpiration(errorCacheExpiration).withTimedOutExpiration(timedOutExceptionTtl).withHardExpirationDelta(hardExpirationDelta).withMaxTtl(maxTtl);
            }

            @Contract(value="_, !null -> !null")
            @Nullable
            public DnsCache get(Config config, @Nullable DnsCache defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    public static ConfigConverter<FrameFormat> ofFrameFormat() {
        return new ConfigConverter<FrameFormat>(){

            @NotNull
            public FrameFormat get(Config config) {
                return this.doGet(config, config.getValue());
            }

            private FrameFormat doGet(Config config, String formatName) {
                switch (formatName) {
                    case "identity": {
                        return FrameFormats.identity();
                    }
                    case "size-prefixed": {
                        return FrameFormats.sizePrefixed();
                    }
                    case "lz4": {
                        LZ4FrameFormat format = LZ4FrameFormat.create();
                        if (config.hasChild("compressionLevel")) {
                            return format.withCompressionLevel(((Integer)config.get(io.activej.config.converter.ConfigConverters.ofInteger(), "compressionLevel")).intValue());
                        }
                        return format;
                    }
                    case "legacy-lz4": {
                        LZ4LegacyFrameFormat legacyFormat = LZ4LegacyFrameFormat.create();
                        if (config.hasChild("compressionLevel")) {
                            legacyFormat.withCompressionLevel(((Integer)config.get(io.activej.config.converter.ConfigConverters.ofInteger(), "compressionLevel")).intValue());
                        }
                        if (config.hasChild("ignoreMissingEndOfStream")) {
                            legacyFormat.withIgnoreMissingEndOfStream(((Boolean)config.get(io.activej.config.converter.ConfigConverters.ofBoolean(), "ignoreMissingEndOfStream")).booleanValue());
                        }
                        return legacyFormat;
                    }
                    case "compound": {
                        Config compoundFormatsConfig = config.getChild("compoundFormats");
                        List formatNames = (List)io.activej.config.converter.ConfigConverters.ofList((ConfigConverter)io.activej.config.converter.ConfigConverters.ofString()).get(compoundFormatsConfig);
                        ArrayList<FrameFormat> formats = new ArrayList<FrameFormat>(formatNames.size());
                        for (String name : formatNames) {
                            if (compoundFormatsConfig.hasChild(name)) {
                                formats.add(this.doGet(compoundFormatsConfig.getChild(name), name));
                                continue;
                            }
                            formats.add(this.doGet(compoundFormatsConfig, name));
                        }
                        return FrameFormats.compound((FrameFormat)((FrameFormat)formats.get(0)), (FrameFormat[])formats.subList(1, formats.size()).toArray(new FrameFormat[0]));
                    }
                }
                throw new IllegalArgumentException("No frame format named " + config.getValue() + " exists");
            }

            public FrameFormat get(Config config, FrameFormat defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }
}

