/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.initializers;

import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.MBeanFormat;
import io.activej.promise.jmx.PromiseStats;
import io.activej.trigger.TriggerResult;
import java.time.Instant;
import java.util.function.BiPredicate;

public final class TriggersHelper {
    public static TriggerResult ofPromiseStats(PromiseStats promiseStats) {
        ExceptionStats exceptionStats = promiseStats.getExceptions();
        return TriggerResult.ofError((ExceptionStats)exceptionStats);
    }

    public static TriggerResult ofPromiseStatsLastError(PromiseStats promiseStats) {
        return TriggersHelper.ofPromiseStats(promiseStats, Instant::isBefore);
    }

    public static TriggerResult ofPromiseStatsLastSuccess(PromiseStats promiseStats) {
        return TriggersHelper.ofPromiseStats(promiseStats, Instant::isAfter);
    }

    public static TriggerResult ofDelay(long timestamp, long maxDelayMillis) {
        if (timestamp == 0L || System.currentTimeMillis() <= timestamp + maxDelayMillis) {
            return TriggerResult.none();
        }
        return TriggerResult.ofValue((Object)MBeanFormat.formatTimestamp((long)timestamp));
    }

    public static boolean maxDelay(long timestamp, long maxDelayMillis) {
        return timestamp != 0L && System.currentTimeMillis() > timestamp + maxDelayMillis;
    }

    private static TriggerResult ofPromiseStats(PromiseStats promiseStats, BiPredicate<Instant, Instant> completeExceptionTime) {
        ExceptionStats exceptionStats = promiseStats.getExceptions();
        Instant lastExceptionTime = exceptionStats.getLastTime();
        if (lastExceptionTime == null) {
            return TriggerResult.none();
        }
        Instant lastCompleteTime = promiseStats.getLastCompleteTime();
        if (lastCompleteTime == null) {
            return TriggerResult.ofError((ExceptionStats)exceptionStats);
        }
        return completeExceptionTime.test(lastCompleteTime, lastExceptionTime) ? TriggerResult.ofError((ExceptionStats)exceptionStats) : TriggerResult.none();
    }
}

