/*
 * Decompiled with CFR 0.152.
 */
package io.activej.launchers.http;

import io.activej.config.Config;
import io.activej.config.ConfigModule;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.ConfigConverters;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.inspector.EventloopInspector;
import io.activej.eventloop.inspector.ThrottlingController;
import io.activej.http.AsyncHttpServer;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpResponse;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.AbstractModule;
import io.activej.inject.module.Module;
import io.activej.inject.module.Modules;
import io.activej.launcher.Launcher;
import io.activej.launchers.initializers.Initializers;
import io.activej.service.ServiceGraphModule;
import java.net.InetSocketAddress;
import java.util.function.Consumer;

public abstract class HttpServerLauncher
extends Launcher {
    public static final String PROPERTIES_FILE = "http-server.properties";
    @Inject
    AsyncHttpServer httpServer;

    @Provides
    Eventloop eventloop(Config config, OptionalDependency<ThrottlingController> throttlingController) {
        return (Eventloop)((Eventloop)Eventloop.create().withInitializer((Consumer)Initializers.ofEventloop((Config)config.getChild("eventloop")))).withInitializer(eventloop -> eventloop.withInspector((EventloopInspector)throttlingController.orElse(null)));
    }

    @Provides
    AsyncHttpServer server(Eventloop eventloop, AsyncServlet rootServlet, Config config) {
        return (AsyncHttpServer)AsyncHttpServer.create((Eventloop)eventloop, (AsyncServlet)rootServlet).withInitializer((Consumer)Initializers.ofHttpServer((Config)config.getChild("http")));
    }

    @Provides
    Config config() {
        return Config.create().with("http.listenAddresses", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(8080))).overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofSystemProperties((String)"config"));
    }

    protected final Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), ConfigModule.create().withEffectiveConfigLogger(), this.getBusinessLogicModule()});
    }

    protected Module getBusinessLogicModule() {
        return Module.empty();
    }

    protected void run() throws Exception {
        this.logger.info("HTTP Server is now available at {}", (Object)String.join((CharSequence)", ", this.httpServer.getHttpAddresses()));
        this.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        HttpServerLauncher launcher = new HttpServerLauncher(){

            @Override
            protected Module getBusinessLogicModule() {
                return new AbstractModule(){

                    @Provides
                    public AsyncServlet servlet(Config config) {
                        String message = config.get("message", "Hello, world!");
                        return request -> HttpResponse.ok200().withPlainText(message);
                    }
                };
            }
        };
        launcher.launch(args);
    }
}

