/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.basic;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.security.MessageDigest;

public class BasicCredentials {
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasicCredentials that = (BasicCredentials)obj;
        byte[] thisBytes = this.password.getBytes(Charsets.UTF_8);
        byte[] thatBytes = that.password.getBytes(Charsets.UTF_8);
        return this.username.equals(that.username) && MessageDigest.isEqual(thisBytes, thatBytes);
    }

    public int hashCode() {
        return 31 * this.username.hashCode() + this.password.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("username", (Object)this.username).add("password", (Object)"**********").toString();
    }
}

