/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.git_changelist_maven_extension;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="git-changelist-maven-extension")
public class Main
extends AbstractMavenLifecycleParticipant {
    private static final String IGNORE_DIRT = "ignore.dirt";
    private static final int ABBREV_LENGTH = 12;
    @Requirement
    private Logger log;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        Properties props = session.getRequest().getUserProperties();
        if ("true".equals(props.getProperty("set.changelist"))) {
            if (!props.containsKey("changelist") && !props.containsKey("scmTag")) {
                int count;
                String hash;
                String fullHash;
                long start = System.nanoTime();
                File dir = session.getRequest().getMultiModuleProjectDirectory();
                this.log.debug("running in " + dir);
                try (Git git = Git.open((File)dir);){
                    Status status = git.status().call();
                    if (!status.isClean()) {
                        TreeSet paths = new TreeSet(status.getUncommittedChanges());
                        paths.addAll(status.getUntracked());
                        String error = "Make sure `git status -s` is empty before using -Dset.changelist: " + paths;
                        if ("true".equals(props.getProperty(IGNORE_DIRT))) {
                            this.log.warn(error);
                        } else {
                            throw new MavenExecutionException(error + " (use -D" + IGNORE_DIRT + " to make this nonfatal)", (Throwable)null);
                        }
                    }
                    Repository repo = git.getRepository();
                    ObjectId head = repo.resolve("HEAD");
                    fullHash = head.name();
                    hash = head.abbreviate(12).name();
                    try (RevWalk walk = new RevWalk(repo);){
                        RevCommit headC = walk.parseCommit((AnyObjectId)head);
                        count = Main.revCount(walk, headC);
                        HashMap encountered = new HashMap();
                        walk.markStart(headC);
                        int commitCount = 0;
                        for (RevCommit c : walk) {
                            ++commitCount;
                            String abbreviated = c.getId().abbreviate(12).name();
                            ArrayList<RevCommit> earlier = (ArrayList<RevCommit>)encountered.get(abbreviated);
                            if (earlier == null) {
                                earlier = new ArrayList<RevCommit>(1);
                                earlier.add(c);
                                encountered.put(abbreviated, earlier);
                                continue;
                            }
                            int thisCount = Main.revCount(walk, c);
                            for (RevCommit other : earlier) {
                                int otherCount = Main.revCount(walk, other);
                                if (otherCount == thisCount) {
                                    throw new MavenExecutionException(Main.summarize(c) + " clashes with " + Main.summarize(other) + " as they would both be identified as " + thisCount + "." + abbreviated, (Throwable)null);
                                }
                                this.log.info(Main.summarize(c) + " would clash with " + Main.summarize(other) + " except they have differing revcounts: " + thisCount + " vs. " + otherCount);
                            }
                        }
                        this.log.debug("Analyzed " + commitCount + " commits for clashes");
                    }
                }
                catch (IOException | GitAPIException x) {
                    throw new MavenExecutionException("Git operations failed", x);
                }
                this.log.debug("Spent " + (System.nanoTime() - start) / 1000L / 1000L + "ms on calculations");
                String value = "-rc" + count + "." + hash;
                this.log.info("Setting: -Dchangelist=" + value + " -DscmTag=" + fullHash);
                props.setProperty("changelist", value);
                props.setProperty("scmTag", fullHash);
            } else {
                this.log.info("Declining to override the `changelist` or `scmTag` properties");
            }
        } else {
            this.log.debug("Skipping Git version setting unless run with -Dset.changelist");
        }
    }

    private static String summarize(RevCommit c) {
        return c.getId().name() + " \u201c" + c.getShortMessage() + "\u201d " + DateTimeFormatter.ISO_LOCAL_DATE.format(Instant.ofEpochSecond(c.getCommitTime()).atZone(ZoneId.systemDefault()));
    }

    private static int revCount(RevWalk walk, RevCommit c) throws IOException, GitAPIException {
        int count = 0;
        try (RevWalk walk2 = new RevWalk(walk.getObjectReader());){
            walk2.markStart(walk2.parseCommit((AnyObjectId)c));
            for (RevCommit c2 : walk2) {
                ++count;
            }
        }
        return count;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Properties props = session.getRequest().getUserProperties();
        if ("true".equals(props.getProperty("set.changelist"))) {
            String changelist = props.getProperty("changelist");
            for (MavenProject project : session.getProjects()) {
                String version = project.getVersion();
                if (version.contains(changelist)) continue;
                this.log.warn(project.getId() + " does not seem to be including ${changelist} in its <version>");
            }
        }
    }
}

