/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.SneakyThrows;
import io.jooby.internal.openapi.commons.io.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ClassSource {
    private final ClassLoader classLoader;

    public ClassSource(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] loadClass(String classname) {
        try (InputStream stream = this.classLoader.getResourceAsStream(classname.replace(".", "/") + ".class");){
            if (stream == null) {
                throw new ClassNotFoundException(classname);
            }
            byte[] byArray = IOUtils.toByteArray(stream);
            return byArray;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public byte[] loadResource(String path) throws IOException {
        try (InputStream stream = this.classLoader.getResourceAsStream(path);){
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            byte[] byArray = IOUtils.toByteArray(stream);
            return byArray;
        }
    }
}

