/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.net.URI;
import java.util.regex.Pattern;
import ratpack.handling.Context;
import ratpack.handling.Redirector;
import ratpack.http.Request;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.server.PublicAddress;

public class DefaultRedirector
implements Redirector {
    private static final Pattern ABSOLUTE_PATTERN = Pattern.compile("^https?://.*");
    public static final Redirector INSTANCE = new DefaultRedirector();

    private DefaultRedirector() {
    }

    @Override
    public void redirect(Context context, int code, Object to) {
        String stringValue = to instanceof URI ? ((URI)to).toASCIIString() : to.toString();
        context.getResponse().status(code);
        String normalizedLocation = this.generateRedirectLocation(context, context.getRequest(), stringValue);
        context.getResponse().getHeaders().set(HttpHeaderConstants.LOCATION, normalizedLocation);
        context.getResponse().send();
    }

    private String generateRedirectLocation(Context ctx, Request request, String path) {
        String generatedPath;
        PublicAddress publicAddress = ctx.get(PublicAddress.class);
        if (ABSOLUTE_PATTERN.matcher(path).matches()) {
            generatedPath = path;
        } else {
            URI host = publicAddress.get();
            generatedPath = path.startsWith("//") ? host.getScheme() + ":" + path : (path.charAt(0) == '/' ? host.toString() + path : host.toString() + this.getParentPath(request.getUri()) + path);
        }
        return generatedPath;
    }

    private String getParentPath(String path) {
        String parentPath = "/";
        int indexOfSlash = path.lastIndexOf(47);
        if (indexOfSlash >= 0) {
            parentPath = path.substring(0, indexOfSlash) + '/';
        }
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        return parentPath;
    }
}

