/*
 * Decompiled with CFR 0.152.
 */
package ratpack.health.internal;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.health.HealthCheck;
import ratpack.health.HealthCheckResults;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.registry.internal.TypeCaching;
import ratpack.render.Renderer;
import ratpack.render.RendererSupport;

public class HealthCheckResultsRenderer
extends RendererSupport<HealthCheckResults> {
    public static final TypeToken<Renderer<HealthCheckResults>> TYPE = TypeCaching.typeToken(new TypeToken<Renderer<HealthCheckResults>>(){});
    private final ByteBufAllocator byteBufAllocator;

    public HealthCheckResultsRenderer(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public void render(Context ctx, HealthCheckResults healthCheckResults) throws Exception {
        ByteBuf buffer = this.byteBufAllocator.buffer();
        boolean first = true;
        boolean unhealthy = false;
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream((OutputStream)new ByteBufOutputStream(buffer)));){
            for (Map.Entry entry : healthCheckResults.getResults().entrySet()) {
                Throwable error;
                if (first) {
                    first = false;
                } else {
                    writer.write("\n");
                }
                String name = (String)entry.getKey();
                HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
                unhealthy = unhealthy || !result.isHealthy();
                ((Writer)writer).append(name).append(" : ").append(result.isHealthy() ? "HEALTHY" : "UNHEALTHY");
                String message = result.getMessage();
                if (message != null) {
                    ((Writer)writer).append(" [").append(message).append("]");
                }
                if ((error = result.getError()) == null) continue;
                ((Writer)writer).append(" [").append(error.toString()).append("]");
            }
        }
        catch (Exception e) {
            buffer.release();
            throw e;
        }
        ctx.getResponse().contentTypeIfNotSet(HttpHeaderConstants.PLAIN_TEXT_UTF8).status(unhealthy ? 503 : 200).send(buffer);
    }
}

