/*
 * Decompiled with CFR 0.152.
 */
package ratpack.logging;

import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.util.Types;

public final class MDCInterceptor
implements ExecInterceptor {
    private final Action<? super Execution> init;

    private MDCInterceptor(Action<? super Execution> init) {
        this.init = init;
    }

    public static MDCInterceptor instance() {
        return MDCInterceptor.withInit(Action.noop());
    }

    public static MDCInterceptor withInit(Action<? super Execution> init) {
        return new MDCInterceptor(init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(Execution execution, ExecInterceptor.ExecType execType, Block executionSegment) throws Exception {
        MDCHolder holder = execution.maybeGet(MDCHolder.TYPE).orElse(null);
        if (holder == null) {
            MDC.clear();
            holder = new MDCHolder();
            this.init.execute(execution);
            execution.add((TypeToken)MDCHolder.TYPE, (Object)holder);
        } else if (holder.map == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(holder.map);
        }
        try {
            executionSegment.execute();
        }
        finally {
            holder.map = MDC.getCopyOfContextMap();
            MDC.clear();
        }
    }

    private static class MDCHolder {
        static final TypeToken<MDCHolder> TYPE = Types.token(MDCHolder.class);
        Map<String, String> map = new HashMap<String, String>();

        private MDCHolder() {
        }
    }
}

