/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import java.util.function.Supplier;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.RegistryBacking;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.CachingBackedRegistry;
import ratpack.registry.internal.DefaultRegistryBuilder;
import ratpack.registry.internal.EmptyRegistry;
import ratpack.registry.internal.HierarchicalRegistry;
import ratpack.registry.internal.SimpleMutableRegistry;
import ratpack.registry.internal.TypeCaching;

public interface Registry {
    default public <O> O get(Class<O> type) throws NotInRegistryException {
        return (O)this.get(TypeCaching.typeToken(type));
    }

    default public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        Optional<O> o = this.maybeGet(type);
        if (o.isPresent()) {
            return o.get();
        }
        throw new NotInRegistryException(type);
    }

    default public <O> Optional<O> maybeGet(Class<O> type) {
        return this.maybeGet(TypeCaching.typeToken(type));
    }

    public <O> Optional<O> maybeGet(TypeToken<O> var1);

    default public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.getAll(TypeCaching.typeToken(type));
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> var1);

    default public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        Iterable<T> all = this.getAll(type);
        for (T t : all) {
            O out = function.apply(t);
            if (out == null) continue;
            return Optional.of(out);
        }
        return Optional.empty();
    }

    default public <T, O> Optional<O> first(Class<T> type, Function<? super T, ? extends O> function) throws Exception {
        return this.first(TypeCaching.typeToken(type), function);
    }

    default public Registry join(Registry child) {
        if (this == EmptyRegistry.INSTANCE) {
            return child;
        }
        if (child == EmptyRegistry.INSTANCE) {
            return this;
        }
        return new HierarchicalRegistry(this, child);
    }

    public static Registry empty() {
        return EmptyRegistry.INSTANCE;
    }

    public static RegistryBuilder builder() {
        return new DefaultRegistryBuilder();
    }

    public static Registry of(Action<? super RegistrySpec> action) throws Exception {
        RegistryBuilder builder = Registry.builder();
        action.execute(builder);
        return builder.build();
    }

    public static Registry backedBy(RegistryBacking registryBacking) {
        return new CachingBackedRegistry(registryBacking);
    }

    @Deprecated
    public static <T> Registry single(Class<T> publicType, Supplier<? extends T> supplier) {
        return Registry.builder().addLazy(publicType, (Supplier)supplier).build();
    }

    public static <T> Registry singleLazy(Class<T> publicType, Supplier<? extends T> supplier) {
        return Registry.builder().addLazy(publicType, (Supplier)supplier).build();
    }

    public static Registry single(Object object) {
        return Registry.builder().add(object).build();
    }

    public static <T> Registry single(Class<? super T> publicType, T implementation) {
        return Registry.builder().add(publicType, (Object)implementation).build();
    }

    public static MutableRegistry mutable() {
        return new SimpleMutableRegistry();
    }
}

