/*
 * Decompiled with CFR 0.152.
 */
package ratpack.reload.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.func.Factory;
import ratpack.util.Exceptions;
import ratpack.util.internal.Paths2;

public class ReloadableFileBackedFactory<T>
implements Factory<T> {
    private final Path file;
    private final boolean reloadable;
    private final Producer<T> producer;
    private final Releaser<T> releaser;
    private final AtomicReference<FileTime> lastModifiedHolder = new AtomicReference<Object>(null);
    private final AtomicReference<String> contentHolder = new AtomicReference();
    private final AtomicReference<T> delegateHolder = new AtomicReference<Object>(null);
    private final Lock lock = new ReentrantLock();

    public ReloadableFileBackedFactory(Path file, boolean reloadable, Producer<T> producer) {
        this(file, reloadable, producer, new NullReleaser());
    }

    public ReloadableFileBackedFactory(Path file, boolean reloadable, Producer<T> producer, Releaser<T> releaser) {
        this.file = file;
        this.reloadable = reloadable;
        this.producer = producer;
        this.releaser = releaser;
        if (!reloadable) {
            try {
                this.refresh();
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        }
    }

    @Override
    public T create() {
        if (!this.reloadable) {
            return this.delegateHolder.get();
        }
        int i = 10;
        while (!Files.exists(this.file, new LinkOption[0]) && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw Exceptions.uncheck(e);
            }
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            return null;
        }
        try {
            if (this.refreshNeeded()) {
                this.refresh();
            }
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        return this.delegateHolder.get();
    }

    private boolean refreshNeeded() throws IOException {
        return !Files.getLastModifiedTime(this.file, new LinkOption[0]).equals(this.lastModifiedHolder.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() throws Exception {
        this.lock.lock();
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(this.file, new LinkOption[0]);
            String content = Paths2.readText(this.file, StandardCharsets.UTF_8);
            if (lastModifiedTime.equals(this.lastModifiedHolder.get()) && content.equals(this.contentHolder.get())) {
                return;
            }
            Object previous = this.delegateHolder.getAndSet(null);
            if (previous != null) {
                this.releaser.release(previous);
            }
            this.delegateHolder.set(this.producer.produce(this.file, content));
            this.lastModifiedHolder.set(lastModifiedTime);
            this.contentHolder.set(content);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class NullReleaser<T>
    implements Releaser<T> {
        private NullReleaser() {
        }

        @Override
        public void release(T thing) {
        }
    }

    public static interface Releaser<T> {
        public void release(T var1);
    }

    public static interface Producer<T> {
        public T produce(Path var1, String var2) throws Exception;
    }
}

