/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.registry.Registry;
import ratpack.server.ReloadInformant;
import ratpack.util.Exceptions;

public class FileBackedReloadInformant
implements ReloadInformant {
    private final Path file;
    private final AtomicReference<FileTime> lastModifiedHolder = new AtomicReference<Object>(null);

    public FileBackedReloadInformant(Path file) {
        this.file = file;
        this.probe();
    }

    private boolean probe() {
        try {
            FileTime nowLastModified = Files.getLastModifiedTime(this.file, new LinkOption[0]);
            FileTime previousLastModified = this.lastModifiedHolder.getAndSet(nowLastModified);
            return !nowLastModified.equals(previousLastModified);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    @Override
    public boolean shouldReload(Registry registry) {
        int i = 10;
        while (!Files.exists(this.file, new LinkOption[0]) && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw Exceptions.uncheck(e);
            }
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            return false;
        }
        try {
            return this.probe();
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    @Override
    public String toString() {
        return "file-backed reload informant: " + this.file.toString();
    }
}

