/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.time.Clock;
import java.util.Optional;
import ratpack.config.ConfigObject;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.error.internal.DefaultProductionErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.FileRenderer;
import ratpack.form.internal.FormParser;
import ratpack.func.Function;
import ratpack.handling.Redirector;
import ratpack.handling.RequestId;
import ratpack.handling.internal.UuidBasedRequestIdGenerator;
import ratpack.health.internal.HealthCheckResultsRenderer;
import ratpack.http.client.HttpClient;
import ratpack.impose.Impositions;
import ratpack.jackson.internal.JsonParser;
import ratpack.jackson.internal.JsonRenderer;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.render.internal.CharSequenceRenderer;
import ratpack.render.internal.OptionalRenderer;
import ratpack.render.internal.PromiseRenderer;
import ratpack.render.internal.PublisherRenderer;
import ratpack.render.internal.RenderableRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.StartupFailureException;
import ratpack.server.Stopper;
import ratpack.sse.ServerSentEventStreamClient;
import ratpack.util.Exceptions;

public abstract class ServerRegistry {
    public static Registry serverRegistry(RatpackServer ratpackServer, Impositions impositions, ExecControllerInternal execController, ServerConfig serverConfig, Function<? super Registry, ? extends Registry> userRegistryFactory) {
        Registry baseRegistry = ServerRegistry.buildBaseRegistry(ratpackServer, impositions, execController, serverConfig);
        Registry userRegistry = ServerRegistry.buildUserRegistry(userRegistryFactory, baseRegistry);
        execController.setInterceptors((ImmutableList<? extends ExecInterceptor>)ImmutableList.copyOf(userRegistry.getAll(ExecInterceptor.class)));
        execController.setInitializers((ImmutableList<? extends ExecInitializer>)ImmutableList.copyOf(userRegistry.getAll(ExecInitializer.class)));
        return baseRegistry.join(userRegistry);
    }

    private static Registry buildUserRegistry(Function<? super Registry, ? extends Registry> userRegistryFactory, Registry baseRegistry) {
        Registry userRegistry;
        try {
            userRegistry = userRegistryFactory.apply(baseRegistry);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new StartupFailureException("Failed to build user registry", e);
        }
        return userRegistry;
    }

    public static Registry buildBaseRegistry(RatpackServer ratpackServer, Impositions impositions, ExecController execController, ServerConfig serverConfig) {
        RegistrySpec baseRegistryBuilder;
        ErrorHandler errorHandler = serverConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        try {
            HttpClient httpClient = HttpClient.of(s -> s.poolSize(0).byteBufAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT).maxContentLength(serverConfig.getMaxContentLength()));
            baseRegistryBuilder = Registry.builder().add(ServerConfig.class, (Object)serverConfig).add(Impositions.class, impositions).add(ByteBufAllocator.class, PooledByteBufAllocator.DEFAULT).add(ExecController.class, execController).add(MimeTypes.class, ActivationBackedMimeTypes.INSTANCE).add(PublicAddress.class, Optional.ofNullable(serverConfig.getPublicAddress()).map(PublicAddress::of).orElseGet(() -> PublicAddress.inferred(serverConfig.getSslContext() == null ? "http" : "https"))).add((TypeToken)Redirector.TYPE, Redirector.standard()).add(ClientErrorHandler.class, errorHandler).add(ServerErrorHandler.class, errorHandler).add((TypeToken)FileRenderer.TYPE, serverConfig.isDevelopment() ? FileRenderer.NON_CACHING : FileRenderer.CACHING).add((TypeToken)PromiseRenderer.TYPE, PromiseRenderer.INSTANCE).add((TypeToken)PublisherRenderer.TYPE, PublisherRenderer.INSTANCE).add((TypeToken)OptionalRenderer.TYPE, OptionalRenderer.INSTANCE).add((TypeToken)RenderableRenderer.TYPE, RenderableRenderer.INSTANCE).add((TypeToken)CharSequenceRenderer.TYPE, CharSequenceRenderer.INSTANCE).add((TypeToken)JsonRenderer.TYPE, JsonRenderer.INSTANCE).add((TypeToken)FormParser.TYPE, FormParser.INSTANCE).add((TypeToken)JsonParser.TYPE, JsonParser.INSTANCE).add(Clock.class, Clock.systemDefaultZone()).add(RatpackServer.class, ratpackServer).add(ObjectMapper.class, new ObjectMapper()).add(Stopper.class, () -> Exceptions.uncheck(() -> {
                ratpackServer.stop();
                return null;
            })).add(HttpClient.class, httpClient).add(ServerSentEventStreamClient.class, ServerSentEventStreamClient.of(httpClient)).add((TypeToken)HealthCheckResultsRenderer.TYPE, new HealthCheckResultsRenderer((ByteBufAllocator)PooledByteBufAllocator.DEFAULT)).add(RequestId.Generator.class, UuidBasedRequestIdGenerator.INSTANCE);
            ServerRegistry.addConfigObjects(serverConfig, (RegistryBuilder)baseRegistryBuilder);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        if (serverConfig.isHasBaseDir()) {
            baseRegistryBuilder.add(FileSystemBinding.class, serverConfig.getBaseDir());
        }
        return baseRegistryBuilder.build();
    }

    private static void addConfigObjects(ServerConfig serverConfig, RegistryBuilder baseRegistryBuilder) {
        for (ConfigObject configObject : serverConfig.getRequiredConfig()) {
            ServerRegistry.addConfigObject(baseRegistryBuilder, configObject);
        }
    }

    private static <T> void addConfigObject(RegistryBuilder baseRegistryBuilder, ConfigObject<T> configObject) {
        baseRegistryBuilder.add((TypeToken)configObject.getTypeToken(), (Object)configObject.getObject());
    }
}

