/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.jmx;

import com.mysql.jdbc.ConnectionPropertiesTransform;
import com.mysql.management.jmx.MysqldDynamicMBean;
import com.mysql.management.jmx.SimpleMysqldDynamicMBean;
import com.mysql.management.jmx.jboss.JBossMysqldDynamicMBean;
import com.mysql.management.util.Exceptions;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class ConnectorMXJPropertiesTransform
implements ConnectionPropertiesTransform {
    private static Class[] mbeanClasses = new Class[]{MysqldDynamicMBean.class, SimpleMysqldDynamicMBean.class, JBossMysqldDynamicMBean.class};
    private MBeanServer mbeanServer;

    public ConnectorMXJPropertiesTransform(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public ConnectorMXJPropertiesTransform() {
        this(MBeanServerFactory.findMBeanServer(null).get(0));
    }

    MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public Properties transformProperties(Properties props) throws SQLException {
        String host = this.getHost();
        String port = this.getPort();
        if (!port.equals("3306")) {
            host = host + ":" + port;
        }
        props.put("HOST", host);
        props.put("PORT", port);
        return props;
    }

    String getHost() {
        return "localhost";
    }

    String getPort() throws SQLException {
        Exceptions.SQLBlock block = new Exceptions.SQLBlock(System.err){

            @Override
            public Object inner() throws Exception {
                return ConnectorMXJPropertiesTransform.this.getPortInner();
            }
        };
        return (String)block.exec();
    }

    private Object getPortInner() throws InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        ObjectName objName = this.getMysqldObjectName();
        String port = (String)this.getMBeanServer().getAttribute(objName, "port");
        return port;
    }

    ObjectName getMysqldObjectName() throws InstanceNotFoundException {
        Set<ObjectName> objectNames = this.getMBeanServer().queryNames(null, null);
        StringBuffer error = this.errorMsgHeader();
        for (ObjectName objectName : objectNames) {
            ObjectInstance objInst = this.getMBeanServer().getObjectInstance(objectName);
            String className = objInst.getClassName();
            if (this.classNameMatch(className)) {
                return objectName;
            }
            this.appendItem(error, objectName, className);
        }
        throw new IllegalStateException(error.toString());
    }

    private void appendItem(StringBuffer error, ObjectName objectName, String className) {
        error.append("[");
        error.append(className);
        error.append("(");
        error.append(objectName.getCanonicalName());
        error.append(")]");
    }

    private StringBuffer errorMsgHeader() {
        StringBuffer error = new StringBuffer();
        error.append("MySQL MBean (");
        for (int i = 0; i < mbeanClasses.length; ++i) {
            error.append(mbeanClasses[i].getName());
            if (i >= mbeanClasses.length - 1) continue;
            error.append(", ");
        }
        error.append(") Not Found in: ");
        return error;
    }

    boolean classNameMatch(String className) {
        for (int i = 0; i < mbeanClasses.length; ++i) {
            if (!mbeanClasses[i].getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

