/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.jdbc.Driver;
import com.mysql.management.util.QueryUtil;
import com.mysql.management.util.SQLRuntimeException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class InitializeUser {
    private String userName;
    private String password;
    private String url;
    private PrintStream err;

    public InitializeUser(int port, String userName, String password, PrintStream err) {
        this.userName = userName;
        this.password = password;
        this.url = "jdbc:mysql://127.0.0.1:" + port + "/mysql";
        this.err = err;
        try {
            Class.forName(Driver.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initializeUser() {
        QueryUtil util;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.url, this.userName, this.password);
            boolean bl = false;
            this.close(conn);
            return bl;
        }
        catch (SQLException e) {
        }
        finally {
            this.close(conn);
        }
        try {
            String NO_PASSWORD = null;
            conn = DriverManager.getConnection(this.url, "root", NO_PASSWORD);
        }
        catch (SQLException e) {
            String msg = "User initialization error. Can not connect as " + this.userName + " with password." + " Can not connect as root without password." + " URL: " + this.url;
            throw new SQLRuntimeException(msg, (Throwable)e, null, null);
        }
        try {
            util = new QueryUtil(conn, this.err);
            util.execute("DELETE from user");
            String sql = "grant all on *.* to ?@'localhost' identified by ? with grant option";
            Object[] params = new Object[]{this.userName, this.password};
            util.execute(sql, params);
            util.execute("flush privileges");
        }
        finally {
            this.close(conn);
        }
        try {
            conn = DriverManager.getConnection(this.url, this.userName, this.password);
            util = new QueryUtil(conn, this.err);
            util.execute("SELECT 1");
            return true;
        }
        catch (SQLException e) {
            String msg = "User initialization error. Can not connect as " + this.userName + " with password" + " after creating user and password." + " URL: " + this.url;
            throw new SQLRuntimeException(msg, (Throwable)e, null, null);
        }
        finally {
            this.close(conn);
        }
    }

    private void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable t) {
                t.printStackTrace(this.err);
            }
        }
    }
}

