/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Streams {
    public static final String RESOURCE_SEPARATOR = "/";
    private static final int END_OF_STREAM = -1;
    private Exceptions exceptions = new Exceptions();

    public void copy(InputStream from, OutputStream to) throws IOException {
        this.copy(from, to, true, false);
    }

    void copy(InputStream from, OutputStream to, boolean buffer, boolean terminateOnFailure) throws IOException {
        if (buffer) {
            from = new BufferedInputStream(from);
            to = new BufferedOutputStream(to);
        }
        while (true) {
            try {
                int i = from.read();
                if (i == -1) break;
                to.write(i);
            }
            catch (Exception e) {
                if (terminateOnFailure) break;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw this.exceptions.toRuntime(e);
            }
        }
        to.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString(InputStream from) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            this.copy(from, buf);
            String string = buf.toString();
            return string;
        }
        finally {
            buf.close();
        }
    }

    public InputStream getResourceAsStream(String name) {
        return this.getResourceAsStream(this.getClass(), name);
    }

    public InputStream getResourceAsStream(Class aClass, String name) {
        InputStream is = aClass.getResourceAsStream(name);
        if (is == null) {
            is = aClass.getResourceAsStream(RESOURCE_SEPARATOR + name);
        }
        if (is == null) {
            String msg = "Resource '" + name + "' not found";
            throw new MissingResourceException(msg, aClass.getName(), name);
        }
        return is;
    }

    public void createFileFromResource(final String resourceName, final File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void inner() throws Exception {
                InputStream is = Streams.this.getResourceAsStream(resourceName);
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        Streams.this.copy(is, fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                finally {
                    is.close();
                }
            }
        };
        block.exec();
    }

    public void expandResourceJar(final File outputDir, final String jarResourceName) {
        Exceptions.VoidBlock block = new Exceptions.VoidBlock(){

            @Override
            public void inner() throws Exception {
                Streams.this.expandResourceJarInner(outputDir, jarResourceName);
            }
        };
        block.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandResourceJarInner(File outputDir, String jarResourceName) throws IOException {
        InputStream is = this.getResourceAsStream(jarResourceName);
        try {
            JarInputStream jis = new JarInputStream(is);
            try {
                this.expandEachEntry(outputDir, jis);
            }
            finally {
                jis.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandEachEntry(File outputDir, JarInputStream jis) throws IOException, FileNotFoundException {
        JarEntry entry;
        while ((entry = jis.getNextJarEntry()) != null) {
            File file = new File(outputDir, entry.getName());
            if (file.exists()) continue;
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File parent = file.getParentFile();
            parent.mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            try {
                this.copy(jis, fos);
            }
            finally {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(String resourceName, PrintStream err) {
        InputStream is = this.getResourceAsStream(resourceName);
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace(err);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace(err);
            }
        }
        return props;
    }
}

