/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import org.apache.felix.obrplugin.PomHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFileMojo
extends AbstractMojo {
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="file")
    protected File file;
    @Parameter(property="obrXml")
    protected String obrXml;
    @Component
    private ArtifactFactory m_factory;

    public MavenProject getProject() throws MojoExecutionException {
        MavenProject project;
        if (this.pomFile != null && this.pomFile.exists()) {
            project = PomHelper.readPom(this.pomFile);
            this.groupId = project.getGroupId();
            this.artifactId = project.getArtifactId();
            this.version = project.getVersion();
            this.packaging = project.getPackaging();
        } else {
            project = PomHelper.buildPom(this.groupId, this.artifactId, this.version, this.packaging);
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("Missing group, artifact, version, or packaging information");
        }
        Artifact bundle = this.m_factory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        project.setArtifact(bundle);
        return project;
    }
}

