/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class ConnectionId {
    final InetSocketAddress address;
    final User ticket;
    private static final int PRIME = 16777619;
    final String serviceName;

    public ConnectionId(User ticket, String serviceName, InetSocketAddress address) {
        this.address = address;
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public User getTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionId) {
            ConnectionId id = (ConnectionId)obj;
            return this.address.equals(id.address) && (this.ticket != null && this.ticket.equals((Object)id.ticket) || this.ticket == id.ticket) && this.serviceName == id.serviceName;
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.address.hashCode() + 16777619 * (16777619 * this.serviceName.hashCode() ^ (this.ticket == null ? 0 : this.ticket.hashCode()));
        return hashcode;
    }
}

