/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.OptionsResponse;
import org.w3c.dom.Element;

public class OptionsMethod
extends DavMethodBase {
    private final Set<String> allowedMethods = new HashSet<String>();
    private final Set<String> complianceClasses = new HashSet<String>();

    public OptionsMethod(String uri) {
        super(uri);
    }

    public OptionsMethod(String uri, String[] optionsEntries) throws IOException {
        this(uri, new OptionsInfo(optionsEntries));
    }

    public OptionsMethod(String uri, OptionsInfo optionsInfo) throws IOException {
        super(uri);
        if (optionsInfo != null) {
            this.setRequestBody(optionsInfo);
        }
    }

    public OptionsResponse getResponseAsOptionsResponse() throws IOException {
        this.checkUsed();
        OptionsResponse or = null;
        Element rBody = this.getRootElement();
        if (rBody != null) {
            or = OptionsResponse.createFromXml(rBody);
        }
        return or;
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.allowedMethods.contains(method.toUpperCase());
    }

    public String[] getAllowedMethods() {
        this.checkUsed();
        return this.allowedMethods.toArray(new String[this.allowedMethods.size()]);
    }

    public boolean hasComplianceClass(String complianceClass) {
        this.checkUsed();
        return this.complianceClasses.contains(complianceClass);
    }

    public String[] getComplianceClasses() {
        this.checkUsed();
        return this.complianceClasses.toArray(new String[this.complianceClasses.size()]);
    }

    @Override
    public String getName() {
        return "OPTIONS";
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        Header dav;
        Header allow = this.getResponseHeader("Allow");
        if (allow != null) {
            for (String method : allow.getValue().split(",")) {
                this.allowedMethods.add(method.trim().toUpperCase());
            }
        }
        if ((dav = this.getResponseHeader("DAV")) != null) {
            for (String cl : dav.getValue().split(",")) {
                this.complianceClasses.add(cl.trim());
            }
        }
    }

    @Override
    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

