/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.ByteArrayInputStream;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ZkIndexSchemaReader {
    private static final Logger log = LoggerFactory.getLogger(ZkIndexSchemaReader.class);
    private final ManagedIndexSchemaFactory managedIndexSchemaFactory;
    private SolrZkClient zkClient;
    private String managedSchemaPath;

    public ZkIndexSchemaReader(ManagedIndexSchemaFactory managedIndexSchemaFactory) {
        this.managedIndexSchemaFactory = managedIndexSchemaFactory;
        ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)managedIndexSchemaFactory.getResourceLoader();
        this.zkClient = zkLoader.getZkController().getZkClient();
        this.managedSchemaPath = zkLoader.getCollectionZkPath() + "/" + managedIndexSchemaFactory.getManagedSchemaResourceName();
        this.createSchemaWatcher();
    }

    public Object getSchemaUpdateLock() {
        return this.managedIndexSchemaFactory.getSchemaUpdateLock();
    }

    public void createSchemaWatcher() {
        log.info("Creating ZooKeeper watch for the managed schema at " + this.managedSchemaPath + " ...");
        try {
            this.zkClient.exists(this.managedSchemaPath, new Watcher(){

                @Override
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    log.info("A schema change: {}, has occurred - updating schema from ZooKeeper ...", (Object)event);
                    try {
                        ZkIndexSchemaReader.this.updateSchema(this);
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK");
                            return;
                        }
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("", (Throwable)e);
                    }
                }
            }, true);
        }
        catch (KeeperException e) {
            String msg = "Error creating ZooKeeper watch for the managed schema";
            log.error("Error creating ZooKeeper watch for the managed schema", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Error creating ZooKeeper watch for the managed schema", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(Watcher watcher) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        Object object = this.getSchemaUpdateLock();
        synchronized (object) {
            ManagedIndexSchema oldSchema = this.managedIndexSchemaFactory.getSchema();
            byte[] data = this.zkClient.getData(this.managedSchemaPath, watcher, stat, true);
            if (stat.getVersion() != oldSchema.schemaZkVersion) {
                log.info("Retrieved schema from ZooKeeper");
                long start = System.nanoTime();
                InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
                ManagedIndexSchema newSchema = oldSchema.reloadFields(inputSource, stat.getVersion());
                this.managedIndexSchemaFactory.setSchema(newSchema);
                long stop = System.nanoTime();
                log.info("Finished refreshing schema in " + TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS) + " ms");
            }
        }
    }
}

